/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class VvcSubpicturesDescriptor
extends DVBExtensionDescriptor {
    LookUpList processing_mode_list = new LookUpList.Builder().add(0, "processing mode undefined").add(1, "no bitstream processing necessary").add(2, "merging of VVC subpictures into one bitstream necessary").add(3, "reserved for future use").add(4, "extraction of VVC subpictures from a bitstream necessary").add(5, "reserved for future use").add(6, "extraction and merging (replacement) of VVC subpictures necessary").add(7, "reserved for future use").build();
    private int default_service_mode;
    private int service_description_present;
    private int number_of_vvc_subpictures;
    private List<SubPicture> subPicturesList = new ArrayList<SubPicture>();
    private int reserved_zero_future_use;
    private int processing_mode;
    private DVBString service_description;

    public VvcSubpicturesDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.default_service_mode = Utils.getInt(b, 3, 1, 128) >> 7;
        this.service_description_present = Utils.getInt(b, 3, 1, 64) >> 6;
        this.number_of_vvc_subpictures = Utils.getInt(b, 3, 1, 63);
        int localOffset = 4;
        for (int i = 0; i < this.number_of_vvc_subpictures; ++i) {
            int component_tag = Utils.getInt(b, localOffset++, 1, 63);
            int vvc_subpicture_id = Utils.getInt(b, localOffset++, 1, 63);
            this.subPicturesList.add(new SubPicture(component_tag, vvc_subpicture_id));
        }
        this.reserved_zero_future_use = Utils.getInt(b, localOffset, 1, 248) >> 3;
        this.processing_mode = Utils.getInt(b, localOffset++, 1, 7);
        if (this.service_description_present == 1) {
            this.service_description = new DVBString(b, localOffset);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("default_service_mode", this.default_service_mode));
        t.add(new KVP("service_description_present", this.service_description_present));
        t.add(new KVP("number_of_vvc_subpictures", this.number_of_vvc_subpictures));
        Utils.addListJTree(t, this.subPicturesList, modus, "subpictures");
        t.add(new KVP("reserved_zero_future_use", this.reserved_zero_future_use));
        t.add(new KVP("processing_mode", this.processing_mode).setDescription(this.processing_mode_list.get(this.processing_mode)));
        if (this.service_description_present == 1) {
            t.add(new KVP("service_description", this.service_description));
        }
        return t;
    }

    public record SubPicture(int component_tag, int vvc_subpicture_id) implements TreeNode
    {
        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            KVP t = new KVP("sub_picture");
            t.add(new KVP("component_tag", this.component_tag));
            t.add(new KVP("vvc_subpicture_id", this.vvc_subpicture_id));
            return t;
        }
    }
}

