/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.intable;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.INTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class IPMACStreamLocationDescriptor
extends INTDescriptor {
    private final int networkId;
    private int originalNetworkId;
    private int transportStreamId;
    private final int serviceId;
    private final int componentTag;

    public IPMACStreamLocationDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.networkId = Utils.getInt(b, 2, 2, 65535);
        this.originalNetworkId = Utils.getInt(b, 4, 2, 65535);
        this.transportStreamId = Utils.getInt(b, 6, 2, 65535);
        this.serviceId = Utils.getInt(b, 8, 2, 65535);
        this.componentTag = Utils.getInt(b, 10, 1, 255);
    }

    @Override
    public String toString() {
        return super.toString() + "transportStreamId=" + this.transportStreamId;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP treeNode = super.getJTreeNode(modus);
        PSI psi = this.parentTableSection.getParentPID().getParentTransportStream().getPsi();
        treeNode.add(new KVP("network_id", this.networkId, psi.getNit().getNetworkName(this.networkId)));
        treeNode.add(new KVP("original_network_id", this.originalNetworkId, Utils.getOriginalNetworkIDString(this.originalNetworkId)));
        treeNode.add(new KVP("transport_stream_id", this.transportStreamId));
        treeNode.add(new KVP("service_id", this.serviceId, psi.getSdt().getServiceName(this.originalNetworkId, this.transportStreamId, this.serviceId)));
        treeNode.add(new KVP("component_tag", this.componentTag));
        return treeNode;
    }

    public int getOriginalNetworkId() {
        return this.originalNetworkId;
    }

    public int getTransportStreamId() {
        return this.transportStreamId;
    }
}

