/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.intable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.INTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TargetIPSlashDescriptor
extends INTDescriptor {
    private List<IPAdress> ipList = new ArrayList<IPAdress>();

    public TargetIPSlashDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        for (int t = 0; t < this.descriptorLength; t += 5) {
            byte[] adress = Utils.getBytes(b, 2 + t, 4);
            int mask = Utils.getInt(b, 6 + t, 1, 255);
            IPAdress a = new IPAdress(adress, mask);
            this.ipList.add(a);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.ipList, modus, "ip_list");
        return t;
    }

    public record IPAdress(byte[] IPv4_addr, int IPv4_slash_mask) implements TreeNode
    {
        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("ip-adress(es) " + Utils.formatIPNumber(this.IPv4_addr) + "/" + this.IPv4_slash_mask));
            s.add(new DefaultMutableTreeNode(new KVP("IPv4_addr", this.IPv4_addr, Utils.formatIPNumber(this.IPv4_addr))));
            s.add(new DefaultMutableTreeNode(new KVP("IPv4_slash_mask", this.IPv4_slash_mask, null)));
            return s;
        }
    }
}

