/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.avs;

import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AVS3AudioDescriptor
extends Descriptor {
    private int audio_codec_id = 0;
    private int sampling_frequency_index = 0;
    private int anc_data_index = 0;
    private int coding_profile = 0;
    private int bitrate_index = 0;
    private int bitstream_type = 0;
    private int channel_number_index = 0;
    private int raw_frame_length = 0;
    private int sampling_frequency = 0;
    private int channel_number = 0;
    private int nn_type = 0;
    private int content_type = 0;
    private int object_channel_number = 0;
    private int hoa_order = 0;
    private int total_bitrate = 0;
    private int resolution = 0;
    private byte[] addition_info;
    private static final int GENERAL_HIGH_RATE_CODING = 0;
    private static final int LOSSLESS_CODING = 1;
    private static final int GENERAL_FULL_RATE_CODING = 2;
    private static final int CHANNEL_SIGNAL = 0;
    private static final int OBJECT_SIGNAL = 1;
    private static final int HYBRID_SIGNAL = 2;
    private static final int HOA_SIGNAL = 3;
    private static final LookUpList channel_number_index_Strings = new LookUpList.Builder().add(0, "Mono").add(1, "Dual channel stereo").add(2, "5.1").add(3, "7.1").add(4, "10.2").add(5, "22.2").add(6, "4.0/FOA").add(7, "5.1.2").add(8, "5.1.4").add(9, "7.1.2").add(10, "7.1.4").add(11, "3-order HOA").add(12, "2-order HOA").add(13, 127, "reserved").build();
    private static LookUpList sampling_frequency_index_Strings = new LookUpList.Builder(new String[]{"192000", "96000", "48000", "44100", "32000", "24000", "22050", "16000", "8000"}).add(9, 15, "reserved").build();
    private static LookUpList bitrate_index_Mono_Strings = new LookUpList.Builder(new String[]{"16", "32", "44", "56", "64", "72", "80", "96", "128", "144", "164", "192"}).add(12, 15, "reserved").build();
    private static LookUpList bitrate_index_Stereo_Strings = new LookUpList.Builder(new String[]{"24", "32", "48", "64", "80", "96", "128", "144", "192", "256", "320"}).add(11, 15, "reserved").build();
    private static LookUpList bitrate_index_5_1_Strings = new LookUpList.Builder(new String[]{"192", "256", "320", "384", "448", "512", "640", "720", "144", "96", "128", "160"}).add(12, 15, "reserved").build();
    private static LookUpList bitrate_index_7_1_Strings = new LookUpList.Builder(new String[]{"192", "480", "256", "384", "576", "640", "128", "160"}).add(8, 15, "reserved").build();
    private static LookUpList bitrate_index_FOA_Strings = new LookUpList.Builder(new String[]{"48", "96", "128", "192", "256"}).add(5, 15, "reserved").build();
    private static LookUpList bitrate_index_5_1_2_Strings = new LookUpList.Builder(new String[]{"152", "320", "480", "576"}).add(4, 15, "reserved").build();
    private static LookUpList bitrate_index_5_1_4_Strings = new LookUpList.Builder(new String[]{"176", "384", "576", "704", "356", "448"}).add(6, 15, "reserved").build();
    private static LookUpList bitrate_index_7_1_2_Strings = new LookUpList.Builder(new String[]{"216", "480", "576", "384", "768"}).add(5, 15, "reserved").build();
    private static LookUpList bitrate_index_7_1_4_Strings = new LookUpList.Builder(new String[]{"240", "608", "384", "512", "832"}).add(5, 15, "reserved").build();
    private static LookUpList bitrate_index_HOA2_Strings = new LookUpList.Builder(new String[]{"192", "256", "320", "384", "480", "512", "640"}).add(7, 15, "reserved").build();
    private static LookUpList bitrate_index_HOA3_Strings = new LookUpList.Builder(new String[]{"256", "320", "384", "512", "640", "896"}).add(6, 15, "reserved").build();
    private static LookUpList[] channel_bitrates = new LookUpList[]{bitrate_index_Mono_Strings, bitrate_index_Stereo_Strings, bitrate_index_5_1_Strings, bitrate_index_7_1_Strings, bitrate_index_FOA_Strings, bitrate_index_5_1_2_Strings, bitrate_index_5_1_4_Strings, bitrate_index_7_1_2_Strings, bitrate_index_7_1_4_Strings, bitrate_index_HOA2_Strings, bitrate_index_HOA3_Strings};
    private static LookUpList audio_codec_id_Strings = new LookUpList.Builder().add(0, "High Rate Coding").add(1, "Lossless Coding").add(2, "Full Rate Coding").build();
    private static LookUpList coding_profile_Strings = new LookUpList.Builder(new String[]{"Basic", "Object Based", "HOA"}).add(3, 7, "reserved").build();
    private static LookUpList nn_type_Strings = new LookUpList.Builder(new String[]{"basic", "low complexity"}).add(2, 7, "reserved").build();
    private static LookUpList content_type_Strings = new LookUpList.Builder().add(0, "channels only").add(1, "objects only").add(2, "channels and objects").add(3, "HOA").build();

    public AVS3AudioDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.audio_codec_id = Utils.getInt(b, offset + 2, 1, 240) >>> 4;
        this.sampling_frequency_index = Utils.getInt(b, offset + 2, 1, 15);
        int ofs = offset + 3;
        if (this.audio_codec_id == 0) {
            this.anc_data_index = Utils.getInt(b, ofs, 1, 128) >>> 7;
            this.coding_profile = Utils.getInt(b, ofs, 1, 112) >>> 4;
            this.bitrate_index = Utils.getInt(b, ofs++, 1, 15);
            this.bitstream_type = Utils.getInt(b, ofs, 1, 128) >>> 7;
            this.channel_number_index = Utils.getInt(b, ofs++, 1, 127);
            this.raw_frame_length = Utils.getInt(b, ofs, 2, 65535);
            ofs += 2;
        } else if (this.audio_codec_id == 1) {
            if (this.sampling_frequency_index == 15) {
                this.sampling_frequency = Utils.getInt(b, ofs, 3, 0xFFFFFF);
                ofs += 3;
            }
            this.anc_data_index = Utils.getInt(b, ofs, 1, 128) >>> 7;
            this.coding_profile = Utils.getInt(b, ofs++, 1, 112) >>> 4;
            this.channel_number = Utils.getInt(b, ofs++, 1, 255);
        } else if (this.audio_codec_id == 2) {
            this.nn_type = Utils.getInt(b, ofs, 1, 224) >>> 5;
            this.content_type = Utils.getInt(b, ofs++, 1, 15);
            if (this.content_type == 0) {
                this.channel_number_index = Utils.getInt(b, ofs++, 1, 254) >>> 1;
            } else if (this.content_type == 1) {
                this.object_channel_number = Utils.getInt(b, ofs++, 1, 254) >>> 1;
            } else if (this.content_type == 2) {
                this.channel_number_index = Utils.getInt(b, ofs++, 1, 254) >>> 1;
                this.object_channel_number = Utils.getInt(b, ofs++, 1, 254) >>> 1;
            } else if (this.content_type == 3) {
                this.hoa_order = Utils.getInt(b, ofs++, 1, 240) >>> 4;
            }
            this.total_bitrate = Utils.getInt(b, ofs, 2, 65535);
            ofs += 2;
        }
        this.resolution = Utils.getInt(b, ofs++, 1, 192) >> 6;
        this.addition_info = Arrays.copyOfRange(b, ofs, this.descriptorLength + 2);
    }

    private static final String audio_codec_id_String(int audio_codec_id) {
        String rc = audio_codec_id_Strings.get(audio_codec_id);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for audio_codec_id:" + audio_codec_id);
    }

    private static final String sampling_frequency_index_String(int sampling_frequency_index) {
        String rc = sampling_frequency_index_Strings.get(sampling_frequency_index);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for sampling_frequency_index:" + sampling_frequency_index);
    }

    private static final String bitrate_index_String(int channel_number_index, int bitrate_index) {
        if (channel_number_index < 0 || channel_number_index > channel_bitrates.length) {
            throw new IllegalArgumentException("Invalid value for channel_number_index:" + channel_number_index);
        }
        String rc = channel_bitrates[channel_number_index].get(bitrate_index);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for bitrate_index:" + bitrate_index);
    }

    private static final String coding_profile_String(int coding_profile) {
        String rc = coding_profile_Strings.get(coding_profile);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for coding_profile:" + coding_profile);
    }

    private static final String bitstream_type_String(int bitstream_type) {
        return switch (bitstream_type) {
            case 0 -> "uniform";
            case 1 -> "non-uniform";
            default -> throw new IllegalArgumentException("Invalid value for bitstream_type:" + bitstream_type);
        };
    }

    private static final String channel_number_index_String(int channel_number_index) {
        String rc = channel_number_index_Strings.get(channel_number_index);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for channel_number_index:" + channel_number_index);
    }

    private static final String object_channel_number_String(int object_channel_number) {
        return new String(Integer.toString(object_channel_number + 1) + " object" + (object_channel_number + 1 == 1 ? "" : "s"));
    }

    private static final String nn_type_String(int nn_type) {
        String rc = nn_type_Strings.get(nn_type);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for nn_type:" + nn_type);
    }

    private static final String content_type_String(int content_type) {
        String rc = content_type_Strings.get(content_type);
        if (rc != null) {
            return rc;
        }
        throw new IllegalArgumentException("Invalid value for content_type:" + content_type);
    }

    private static final String resolution_String(int resolution) {
        return switch (resolution) {
            case 0 -> "8 bits";
            case 1 -> "16 bits";
            case 2 -> "24 bits";
            case 3 -> "reserved";
            default -> throw new IllegalArgumentException("Invalid value for resolution:" + resolution);
        };
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("audio_codec_id", this.audio_codec_id, AVS3AudioDescriptor.audio_codec_id_String(this.audio_codec_id))));
        if (this.audio_codec_id == 1 && this.sampling_frequency_index == 15) {
            t.add(new DefaultMutableTreeNode(new KVP("sampling_frequency", this.sampling_frequency)));
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("sampling_frequency_index", this.sampling_frequency_index, AVS3AudioDescriptor.sampling_frequency_index_String(this.sampling_frequency_index))));
        }
        if (this.audio_codec_id == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("anc_data_index", this.anc_data_index)));
            t.add(new DefaultMutableTreeNode(new KVP("coding_profile", this.coding_profile, AVS3AudioDescriptor.coding_profile_String(this.coding_profile))));
            t.add(new DefaultMutableTreeNode(new KVP("bitrate_index", this.bitrate_index, AVS3AudioDescriptor.bitrate_index_String(this.channel_number_index, this.bitrate_index))));
            t.add(new DefaultMutableTreeNode(new KVP("bitstream_type", this.bitstream_type, AVS3AudioDescriptor.bitstream_type_String(this.bitstream_type))));
            t.add(new DefaultMutableTreeNode(new KVP("channel_number_index", this.channel_number_index, AVS3AudioDescriptor.channel_number_index_String(this.channel_number_index))));
            t.add(new DefaultMutableTreeNode(new KVP("raw_frame_length", this.raw_frame_length)));
        } else if (this.audio_codec_id == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("anc_data_index", this.anc_data_index)));
            t.add(new DefaultMutableTreeNode(new KVP("coding_profile", this.coding_profile, AVS3AudioDescriptor.coding_profile_String(this.coding_profile))));
            t.add(new DefaultMutableTreeNode(new KVP("channel_number", this.channel_number)));
        } else if (this.audio_codec_id == 2) {
            t.add(new DefaultMutableTreeNode(new KVP("nn_type", this.nn_type, AVS3AudioDescriptor.nn_type_String(this.nn_type))));
            t.add(new DefaultMutableTreeNode(new KVP("content_type", this.content_type, AVS3AudioDescriptor.content_type_String(this.content_type))));
            if (this.content_type == 0 || this.content_type == 2) {
                t.add(new DefaultMutableTreeNode(new KVP("channel_number_index", this.channel_number_index, AVS3AudioDescriptor.channel_number_index_String(this.channel_number_index))));
            }
            if (this.content_type == 1 || this.content_type == 2) {
                t.add(new DefaultMutableTreeNode(new KVP("object_channel_number", this.object_channel_number, AVS3AudioDescriptor.object_channel_number_String(this.object_channel_number))));
            }
            if (this.content_type == 3) {
                t.add(new DefaultMutableTreeNode(new KVP("hoa_order", this.hoa_order)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("total_bitrate", this.total_bitrate)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("resolution", this.resolution, AVS3AudioDescriptor.resolution_String(this.resolution))));
        if (this.addition_info.length > 0) {
            t.add(new KVP("addition_info", this.addition_info));
        }
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "AVS3 Audio Descriptor";
    }
}

