/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CosBatSelectionDescriptor
extends Descriptor {
    int bouquet_id;
    int selector_type;
    int usage_id;
    DVBString region_name;
    byte[] databyte;

    public CosBatSelectionDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.bouquet_id = Utils.getInt(b, 2, 2, 65535);
        this.selector_type = Utils.getInt(b, 4, 1, 255);
        if (this.selector_type == 1) {
            this.usage_id = Utils.getInt(b, 5, 1, 255);
        } else if (this.selector_type == 2) {
            this.region_name = new DVBString(b, 5);
        } else if (this.selector_type != 3) {
            this.databyte = Utils.getBytes(b, 5, this.descriptorLength - 3);
        }
    }

    @Override
    public String getDescriptorname() {
        return "cos_bat_selection_descriptor";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("bouquet_id", this.bouquet_id));
        t.add(new KVP("selector_type", this.selector_type).setDescription(CosBatSelectionDescriptor.getSelectorTypeString(this.selector_type)));
        if (this.selector_type == 1) {
            t.add(new KVP("usage_id", this.usage_id));
        } else if (this.selector_type == 2) {
            t.add(new KVP("region_name", this.region_name));
        } else if (this.selector_type != 3) {
            t.add(new KVP("databyte", this.databyte));
        }
        return t;
    }

    private static String getSelectorTypeString(int selector_type) {
        return switch (selector_type) {
            case 1 -> "usage_id";
            case 2 -> "Region name";
            case 3 -> "Wildcard";
            default -> "reserved for future use";
        };
    }

    public int getBouquet_id() {
        return this.bouquet_id;
    }

    public int getSelector_type() {
        return this.selector_type;
    }

    public int getUsage_id() {
        return this.usage_id;
    }

    public DVBString getRegion_name() {
        return this.region_name;
    }

    public byte[] getDatabyte() {
        return this.databyte;
    }
}

