/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CosInformationParametersDescriptor
extends Descriptor {
    private final List<InformationParameter> informationParameters = new ArrayList<InformationParameter>();

    public CosInformationParametersDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int info_parameter_length;
        for (int t = 0; t < this.descriptorLength; t += 2 + info_parameter_length) {
            int info_parameter_id = Utils.getInt(b, offset + t + 2, 1, 255);
            info_parameter_length = Utils.getInt(b, offset + t + 3, 1, 255);
            byte[] info_parameter_byte = Utils.getBytes(b, offset + t + 4, info_parameter_length);
            this.informationParameters.add(new InformationParameter(info_parameter_id, info_parameter_length, info_parameter_byte));
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.informationParameters, modus, "Information Parameters");
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "cos_information_parameters_descriptor";
    }

    public record InformationParameter(int info_parameter_id, int info_parameter_length, byte[] info_parameter_byte) implements TreeNode
    {
        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("InformationParameter"));
            t.add(new DefaultMutableTreeNode(new KVP("info_parameter_id", this.info_parameter_id, InformationParameter.getInfoParameterIdDescription(this.info_parameter_id))));
            t.add(new DefaultMutableTreeNode(new KVP("info_parameter_length", this.info_parameter_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("info_parameter_byte", this.info_parameter_byte, null)));
            return t;
        }

        private static String getInfoParameterIdDescription(int info_parameter_id) {
            return switch (info_parameter_id) {
                case 1 -> "Call center phone number";
                case 2 -> "Web address";
                default -> "Reserved for future use";
            };
        }
    }
}

