/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.casema;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ZiggoVodDeliveryDescriptor
extends Descriptor {
    private final List<VODChannel> channelList = new ArrayList<VODChannel>();

    public ZiggoVodDeliveryDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 11) {
            String frequency = Utils.getBCD(b, 2 * (offset + 2 + t), 8);
            int FEC_outer = Utils.getInt(b, offset + 7 + t, 1, 15);
            int modulation = Utils.getInt(b, offset + 8 + t, 1, 255);
            String symbol_rate = Utils.getBCD(b, (offset + 9 + t) * 2, 7);
            int FEC_inner = Utils.getInt(b, offset + 12 + t, 1, 15);
            VODChannel s = new VODChannel(frequency, FEC_outer, modulation, symbol_rate, FEC_inner);
            this.channelList.add(s);
        }
    }

    @Override
    public String getDescriptorname() {
        return "Video On Demand delivery descriptor";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.channelList, modus, "vod_channels");
        return t;
    }

    public static class VODChannel
    implements TreeNode {
        private String frequency;
        private int FEC_outer;
        private int modulation;
        private String symbol_rate;
        private int FEC_inner;

        public int getFEC_inner() {
            return this.FEC_inner;
        }

        public void setFEC_inner(int fec_inner) {
            this.FEC_inner = fec_inner;
        }

        public int getFEC_outer() {
            return this.FEC_outer;
        }

        public String getFEC_outerString() {
            switch (this.getFEC_outer()) {
                case 0: {
                    return "not defined";
                }
                case 1: {
                    return "no outer FEC coding";
                }
                case 2: {
                    return "RS(204/188)";
                }
            }
            return "reserved for future use";
        }

        public String getModulationString() {
            switch (this.getModulation()) {
                case 0: {
                    return "not defined";
                }
                case 1: {
                    return "16-QAM";
                }
                case 2: {
                    return "32-QAM";
                }
                case 3: {
                    return "64-QAM";
                }
                case 4: {
                    return "128-QAM";
                }
                case 5: {
                    return "256-QAM";
                }
            }
            return "reserved for future use";
        }

        public String getFEC_innerString() {
            switch (this.getFEC_inner()) {
                case 0: {
                    return "not defined";
                }
                case 1: {
                    return "1/2 conv. code rate";
                }
                case 2: {
                    return "2/3 conv. code rate";
                }
                case 3: {
                    return "3/4 conv. code rate";
                }
                case 4: {
                    return "5/6 conv. code rate";
                }
                case 5: {
                    return "7/8 conv. code rate";
                }
                case 6: {
                    return "8/9 conv. code rate";
                }
                case 7: {
                    return "3/5 conv. code rate";
                }
                case 8: {
                    return "4/5 conv. code rate";
                }
                case 9: {
                    return "9/10 conv. code rate";
                }
                case 15: {
                    return "no conv. Coding";
                }
            }
            return "reserved for future use";
        }

        public void setFEC_outer(int fec_outer) {
            this.FEC_outer = fec_outer;
        }

        public int getModulation() {
            return this.modulation;
        }

        public void setModulation(int modulation) {
            this.modulation = modulation;
        }

        public String getFrequency() {
            return this.frequency;
        }

        public void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public String getSymbol_rate() {
            return this.symbol_rate;
        }

        public void setSymbol_rate(String symbol_rate) {
            this.symbol_rate = symbol_rate;
        }

        public String toString() {
            return super.toString() + "Frequency=" + this.getFrequency() + ", FEC_outer=" + this.getFEC_outerString() + ", modulation=" + this.getModulationString() + ", Symbol Rate=" + this.getSymbol_rate() + ", FEC_inner=" + this.getFEC_innerString();
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("VOD_channel"));
            t.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, null)));
            t.add(new DefaultMutableTreeNode(new KVP("FEC_outer", this.FEC_outer, this.getFEC_outerString())));
            t.add(new DefaultMutableTreeNode(new KVP("modulation", this.modulation, this.getModulationString())));
            t.add(new DefaultMutableTreeNode(new KVP("symbol_rate", this.symbol_rate, null)));
            t.add(new DefaultMutableTreeNode(new KVP("FEC_inner", this.FEC_inner, this.getFEC_innerString())));
            return t;
        }

        public VODChannel(String frequency, int fec_outer, int modulation, String symbol_rate, int fec_inner) {
            this.frequency = frequency;
            this.FEC_outer = fec_outer;
            this.modulation = modulation;
            this.symbol_rate = symbol_rate;
            this.FEC_inner = fec_inner;
        }
    }
}

