/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ciplus;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CIProtectionDescriptor
extends Descriptor {
    private final int freeCIModeFlag;
    private final int matchBrandFlag;
    private int numberOfEntries;
    private final List<BrandIdentifier> brandList = new ArrayList<BrandIdentifier>();
    private byte[] privateDataByte;

    public CIProtectionDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.freeCIModeFlag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.matchBrandFlag = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        int t = 0;
        if (this.matchBrandFlag == 1) {
            ++t;
            this.numberOfEntries = Utils.getInt(b, offset + 3, 1, 255);
            for (int i = 0; i < this.numberOfEntries; ++i) {
                BrandIdentifier bi = new BrandIdentifier(Utils.getInt(b, offset + 4 + 2 * i, 2, 65535));
                this.brandList.add(bi);
                t += 2;
            }
        }
        this.privateDataByte = Utils.copyOfRange(b, offset + 3 + t, offset + this.descriptorLength + 2);
    }

    @Override
    public String getDescriptorname() {
        return "CI Protection Descriptor";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("free_ci_mode_flag", this.freeCIModeFlag, this.freeCIModeFlag == 1 ? "streams do require CI Plus protection" : "streams do not require CI Plus protection")));
        t.add(new DefaultMutableTreeNode(new KVP("match_brand_flag", this.matchBrandFlag, this.matchBrandFlag == 1 ? "service has chosen to set CICAM brands." : "service has no chosen CICAM brands")));
        if (this.matchBrandFlag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("number_of_entries", this.numberOfEntries, null)));
            Utils.addListJTree(t, this.brandList, modus, "brand_identifier_list");
        }
        if (this.privateDataByte != null && this.privateDataByte.length > 0) {
            t.add(new DefaultMutableTreeNode(new KVP("private_data_bytes", this.privateDataByte, null)));
        }
        return t;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }

    public void setPrivateDataByte(byte[] privateDataByte) {
        this.privateDataByte = privateDataByte;
    }

    public static class BrandIdentifier
    implements TreeNode {
        private final int brandId;

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            return new DefaultMutableTreeNode(new KVP("cicam_brand_identifier", this.brandId, null));
        }

        public BrandIdentifier(int brandId) {
            this.brandId = brandId;
        }
    }
}

