/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.dtg;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.logicalchannel.AbstractLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class LogicalChannelDescriptor
extends AbstractLogicalChannelDescriptor {
    public LogicalChannelDescriptor(byte[] b, int offset, TableSection parent, DescriptorContext descriptorContext) {
        super(b, offset, parent, descriptorContext);
        for (int t = 0; t < this.descriptorLength; t += 4) {
            int serviceId = Utils.getInt(b, offset + 2 + t, 2, 65535);
            int reserved = Utils.getInt(b, offset + t + 4, 1, 252) >> 2;
            int chNumber = Utils.getInt(b, offset + t + 4, 2, 1023);
            LogicalChannel s = new LogicalChannel(serviceId, reserved, chNumber);
            this.channelList.add(s);
        }
    }

    @Override
    public String getDescriptorname() {
        return "DTG Logical Channel Descriptor";
    }

    public class LogicalChannel
    extends AbstractLogicalChannelDescriptor.AbstractLogicalChannel {
        public LogicalChannel(int service_id, int reserved, int logical_channel_number) {
            super(service_id, 1, reserved, logical_channel_number);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP(LogicalChannelDescriptor.this.createNodeLabel(this.service_id, this.logical_channel_number)));
            s.add(new DefaultMutableTreeNode(new KVP("service_id", this.service_id, null)));
            s.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            s.add(new DefaultMutableTreeNode(new KVP("logical_channel_number", this.logical_channel_number, null)));
            return s;
        }
    }
}

