/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.dtg;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ServiceAttributeDescriptor
extends Descriptor {
    List<ServiceAttribute> serviceAttributeList = new ArrayList<ServiceAttribute>();

    public ServiceAttributeDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 3) {
            int service_id = Utils.getInt(b, offset + 2 + t, 2, 65535);
            int reserved = Utils.getInt(b, offset + t + 4, 1, 252) >> 2;
            int numeric_selection_flag = Utils.getInt(b, offset + t + 4, 1, 2) >> 1;
            int visible_service_flag = Utils.getInt(b, offset + t + 4, 1, 1);
            ServiceAttribute s = new ServiceAttribute(this, service_id, reserved, numeric_selection_flag, visible_service_flag);
            this.serviceAttributeList.add(s);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.serviceAttributeList, modus, "Service Attributes");
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "DTG Service attribute descriptor";
    }

    public class ServiceAttribute
    implements TreeNode {
        private int service_id;
        private int reserved;
        private int numeric_selection_flag;
        private int visible_service_flag;

        public ServiceAttribute(ServiceAttributeDescriptor this$0, int service_id, int reserved, int numeric_selection_flag, int visible_service_flag) {
            this.service_id = service_id;
            this.reserved = reserved;
            this.numeric_selection_flag = numeric_selection_flag;
            this.visible_service_flag = visible_service_flag;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("Service attribute"));
            s.add(new DefaultMutableTreeNode(new KVP("service_id", this.service_id, null)));
            s.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            s.add(new DefaultMutableTreeNode(new KVP("numeric_selection_flag", this.numeric_selection_flag, null)));
            s.add(new DefaultMutableTreeNode(new KVP("visible_service_flag", this.visible_service_flag, this.getBehaviourString(this.numeric_selection_flag, this.visible_service_flag))));
            return s;
        }

        private String getBehaviourString(int numeric_selection_flag, int visible_service_flag) {
            if (visible_service_flag == 1) {
                return "Service is visible and selectable";
            }
            if (numeric_selection_flag == 1) {
                return "Service is hidden but selectable through direct numeric entry";
            }
            return "Service is hidden and non-selectable";
        }
    }
}

