/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class M7OperatorOptionsDescriptor
extends M7Descriptor {
    private final int parental_control_rating;
    private final int default_char_set;
    private final int subtitles_enabled;
    private final int special_regions_setup;

    public M7OperatorOptionsDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.parental_control_rating = Utils.getInt(b, 2, 1, 255);
        this.default_char_set = Utils.getInt(b, 3, 1, 255);
        this.subtitles_enabled = Utils.getInt(b, 4, 1, 128) >>> 7;
        this.special_regions_setup = Utils.getInt(b, 4, 1, 64) >>> 6;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("parental_control_rating", this.parental_control_rating, this.getParentalControlString()));
        t.add(new KVP("default_char_set", this.default_char_set, this.getEncodingTypeString()));
        t.add(new KVP("subtitles_enabled", this.subtitles_enabled));
        t.add(new KVP("special_regions_setup", this.special_regions_setup, null));
        return t;
    }

    public String getEncodingTypeString() {
        return M7OperatorOptionsDescriptor.getEncodingType(this.default_char_set);
    }

    public String getParentalControlString() {
        if (this.parental_control_rating == 0) {
            return "undefined";
        }
        return this.parental_control_rating + 3 + " +";
    }

    private static String getEncodingType(int charSet) {
        return switch (charSet) {
            case 1 -> "ISO/IEC 8859-5";
            case 2 -> "ISO/IEC 8859-6";
            case 3 -> "ISO/IEC 8859-7";
            case 4 -> "ISO/IEC 8859-8";
            case 5 -> "ISO/IEC 8859-9";
            case 6 -> "ISO/IEC 8859-10";
            case 7 -> "ISO/IEC 8859-11";
            case 8 -> "ISO/IEC 8859-12";
            case 9 -> "ISO/IEC 8859-13";
            case 10 -> "ISO/IEC 8859-14";
            case 11 -> "ISO/IEC 8859-15";
            case 16 -> "Illegal value";
            case 17 -> "ISO/IEC 10646-1";
            case 18 -> "KSX1001-2004";
            case 19 -> "GB-2312-1980";
            case 20 -> "Big5 subset of ISO/IEC 10646-1";
            case 21 -> "UTF-8 encoding of ISO/IEC 10646-1";
            default -> "reserved for future use";
        };
    }

    public int getParental_control_rating() {
        return this.parental_control_rating;
    }

    public int getDefault_char_set() {
        return this.default_char_set;
    }

    public int getSubtitles_enabled() {
        return this.subtitles_enabled;
    }

    public int getSpecial_regions_setup() {
        return this.special_regions_setup;
    }
}

