/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.opencable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class EBPDescriptor
extends Descriptor {
    private int num_partitions;
    private int timescale_flag;
    private int reserved;
    private int ticks_per_second;
    private int EBP_distance_width_minus_1;
    private List<Partition> partitionList = new ArrayList<Partition>();

    public EBPDescriptor(byte[] bytes, int offset, TableSection parent) {
        super(bytes, offset, parent);
        if (this.descriptorLength > 0) {
            this.num_partitions = Utils.getInt(bytes, offset + 2, 1, 248) >> 3;
            this.timescale_flag = Utils.getInt(bytes, offset + 2, 1, 4) >> 2;
            this.reserved = Utils.getInt(bytes, offset + 2, 1, 3);
            int localOffset = offset + 3;
            if (this.timescale_flag == 1) {
                this.ticks_per_second = Utils.getInt(bytes, localOffset, 3, 0xFFFFF8) >> 3;
                this.EBP_distance_width_minus_1 = Utils.getInt(bytes, localOffset + 2, 1, 7);
                localOffset += 3;
            }
            BitSource bitSource = new BitSource(bytes, localOffset);
            for (int i = 0; i < this.num_partitions; ++i) {
                Partition partition = new Partition(this, bitSource, this.EBP_distance_width_minus_1 + 1);
                this.partitionList.add(partition);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        if (this.descriptorLength > 0) {
            t.add(new DefaultMutableTreeNode(new KVP("num_partitions", this.num_partitions, null)));
            t.add(new DefaultMutableTreeNode(new KVP("timescale_flag", this.timescale_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            if (this.timescale_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("ticks_per_second", this.ticks_per_second, "precision, in ticks per second, of the EBP_distance field")));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_distance_width_minus_1", this.EBP_distance_width_minus_1, " length, in bytes (minus one), of the EBP_distance field")));
            }
            if (!this.partitionList.isEmpty()) {
                Utils.addListJTree(t, this.partitionList, modus, "Partitions");
            }
        }
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "EBP_descriptor";
    }

    private class Partition
    implements TreeNode {
        private int EBP_data_explicit_flag;
        private int representation_id_flag;
        private int partition_id;
        private int reserved;
        private int EBP_PID;
        private int reserved2;
        private int boundary_flag;
        private byte[] EBP_distance;
        private int SAP_type_max;
        private int reserved3;
        private int reserved4;
        private int acquisition_time_flag;
        private long representation_id;

        public Partition(EBPDescriptor eBPDescriptor, BitSource bitSource, int ebp_distance_width) {
            this.EBP_data_explicit_flag = bitSource.readBits(1);
            this.representation_id_flag = bitSource.readBits(1);
            this.partition_id = bitSource.readBits(5);
            if (this.EBP_data_explicit_flag == 0) {
                this.reserved = bitSource.readBits(1);
                this.EBP_PID = bitSource.readBits(13);
                this.reserved2 = bitSource.readBits(3);
            } else {
                this.boundary_flag = bitSource.readBits(1);
                this.EBP_distance = bitSource.readBytes(ebp_distance_width);
                if (this.boundary_flag == 1) {
                    this.SAP_type_max = bitSource.readBits(3);
                    this.reserved3 = bitSource.readBits(4);
                } else {
                    this.reserved4 = bitSource.readBits(7);
                }
                this.acquisition_time_flag = bitSource.readBits(1);
                if (this.representation_id_flag == 1) {
                    this.representation_id = bitSource.readBitsLong(64);
                }
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Partition"));
            t.add(new DefaultMutableTreeNode(new KVP("EBP_data_explicit_flag", this.EBP_data_explicit_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("representation_id_flag", this.representation_id_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("partition_id", this.partition_id, null)));
            if (this.EBP_data_explicit_flag == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_PID", this.EBP_PID, null)));
                t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("boundary_flag", this.boundary_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_distance", this.EBP_distance, null)));
                if (this.boundary_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("SAP_type_max", this.SAP_type_max, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved3, null)));
                } else {
                    t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved4, null)));
                }
                t.add(new DefaultMutableTreeNode(new KVP("acquisition_time_flag", this.acquisition_time_flag, null)));
                if (this.representation_id_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("representation_id", this.representation_id, null)));
                }
            }
            return t;
        }
    }
}

