/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class VirtualServiceIDDescriptor
extends Descriptor {
    private int virtual_service_id;
    private byte[] reserved_future_use;

    public VirtualServiceIDDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.virtual_service_id = Utils.getInt(b, 2, 2, 65535);
        this.reserved_future_use = Utils.getBytes(b, 4, this.descriptorLength - 2);
    }

    @Override
    public String getDescriptorname() {
        return "Virtual Service ID Descriptor";
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.add(new KVP("virtual_service_id", this.virtual_service_id));
        t.add(new KVP("reserved_future_use", this.reserved_future_use));
        return t;
    }

    public int getVirtual_service_id() {
        return this.virtual_service_id;
    }

    public byte[] getReserved_future_use() {
        return this.reserved_future_use;
    }
}

