/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.upc;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class UPCLogicalChannelDescriptor
extends Descriptor {
    private List<LogicalChannel> channelList = new ArrayList<LogicalChannel>();

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.channelList, modus, "logical_channels");
        return t;
    }

    public UPCLogicalChannelDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 6) {
            int region = Utils.getInt(b, offset + 3 + t, 1, 255);
            int city = Utils.getInt(b, offset + t + 4, 2, 65535);
            int chNumber = Utils.getInt(b, offset + t + 6, 2, 65535);
            LogicalChannel s = new LogicalChannel(region, city, chNumber);
            this.channelList.add(s);
        }
    }

    @Override
    public String getDescriptorname() {
        return "UPC_logic_channel_descriptor";
    }

    public int getLogicalChannelNumber() {
        if (this.channelList != null && this.channelList.size() > 0) {
            return this.channelList.get(0).getLogicalChannelNumber();
        }
        return -1;
    }

    public static class LogicalChannel
    implements TreeNode {
        private final int city_code;
        private final int region_code;
        private int logicalChannelNumber;

        public LogicalChannel(int regionCode, int cityCode, int number) {
            this.city_code = cityCode;
            this.region_code = regionCode;
            this.logicalChannelNumber = number;
        }

        public int getLogicalChannelNumber() {
            return this.logicalChannelNumber;
        }

        public void setLogicalChannelNumber(int serviceType) {
            this.logicalChannelNumber = serviceType;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("logical_channel " + this.logicalChannelNumber));
            s.add(new DefaultMutableTreeNode(new KVP("region_code", this.region_code, null)));
            s.add(new DefaultMutableTreeNode(new KVP("city_code", this.city_code, null)));
            s.add(new DefaultMutableTreeNode(new KVP("logical_channel_number", this.logicalChannelNumber, null)));
            return s;
        }
    }
}

