/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.uwa;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class CUVVVideoStreamDescriptor
extends Descriptor {
    private final long cuvv_tag;
    private final int cuva_version_map;
    private final int terminal_provide_code;
    private final int terminal_provide_oriented_code;
    private static LookUpList vivid_version_strings = new LookUpList.Builder().add(5, "1.0").add(6, "2.0").add(7, "3.0").add(8, "4.0").build();

    public CUVVVideoStreamDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.cuvv_tag = Utils.getInt(b, offset + 2, 4, -1);
        this.cuva_version_map = Utils.getInt(b, offset + 6, 2, 65535);
        this.terminal_provide_code = Utils.getInt(b, offset + 8, 2, 65535);
        this.terminal_provide_oriented_code = Utils.getInt(b, offset + 10, 2, 65535);
    }

    private static String FourCC(long v) {
        char[] cccc = new char[]{Character.forDigit((int)(v & 0xFFFFFFFFFF000000L) >> 24, 10), Character.forDigit((int)(v & 0xFF0000L) >> 16, 10), Character.forDigit((int)(v & 0xFF00L) >> 8, 10), Character.forDigit((int)(v & 0xFFL), 10)};
        return new String(cccc);
    }

    private static String toHexString16(int val) {
        return "0x" + String.format("%1$04x", val);
    }

    private static String toHexString32(long val) {
        return "0x" + String.format("%1$08x", val);
    }

    private static String VersionMap(int val) {
        Object res = "";
        for (int i = 0; i < 16; ++i) {
            if ((val >> i & 1) == 0) continue;
            res = (String)res + (i + 1) + " ";
        }
        return ((String)res).length() != 0 ? "Versions present: " + (String)res : "No versions specified.";
    }

    private static String HighestVersion(int val) {
        String res = vivid_version_strings.get(val);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Invalid value in terminal_provide_oriented_code:" + val);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("cuvv_tag", CUVVVideoStreamDescriptor.toHexString32(this.cuvv_tag), CUVVVideoStreamDescriptor.FourCC(this.cuvv_tag))));
        t.add(new DefaultMutableTreeNode(new KVP("cuva_version_map", this.cuva_version_map, CUVVVideoStreamDescriptor.VersionMap(this.cuva_version_map))));
        t.add(new DefaultMutableTreeNode(new KVP("terminal_provide_code", this.terminal_provide_code, CUVVVideoStreamDescriptor.toHexString16(this.terminal_provide_code))));
        t.add(new DefaultMutableTreeNode(new KVP("terminal_provide_oriented_code", this.terminal_provide_oriented_code, CUVVVideoStreamDescriptor.HighestVersion(this.terminal_provide_oriented_code))));
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "CUVV Video Stream Descriptor";
    }
}

