/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.scte35;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SCTE35Descriptor
extends Descriptor {
    private final byte[] identifier;

    public SCTE35Descriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.identifier = Utils.getBytes(b, offset + 2, 4);
    }

    @Override
    public String getDescriptorname() {
        return SCTE35Descriptor.getDescriptorname(this.descriptorTag, this.parentTableSection);
    }

    public static String getDescriptorname(int tag, TableSection tableSection) {
        switch (tag) {
            case 0: {
                return "avail_descriptor";
            }
            case 1: {
                return "DTMF_descriptor";
            }
            case 2: {
                return "segmentation_descriptor";
            }
            case 3: {
                return "DVB-time_descriptor";
            }
            case 4: {
                return "audio_descriptor";
            }
        }
        return "Reserved for future SCTE splice_descriptors";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("identifier", this.identifier, null)));
        return t;
    }
}

