/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.scte35;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.scte35.SCTE35Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class SegmentationDescriptor
extends SCTE35Descriptor {
    LookUpList segmentationUpidTypeList = new LookUpList.Builder().add(0, "Not Used").add(1, "User Defined").add(2, "ISCI").add(3, "Ad-ID").add(4, "UMID (SMPTE 330M)").add(5, "ISAN").add(6, "ISAN (Formerly known as V-ISAN)").add(7, "TID (Tribune Media Systems Program identifier)").add(8, "TI (AiringID ,Formerly Turner ID)").add(9, "ADI (CableLabs metadata identifier)").add(10, "EIDR").add(11, "ATSC Content Identifier").add(12, "MPU()").add(13, "MID()").add(14, "ADS Information").add(15, "URI").add(31, 255, "Reserved").build();
    LookUpList segmentationTypeIdList = new LookUpList.Builder().add(0, "Not Indicated").add(1, "Content Identification").add(16, "Program Start").add(17, "Program End").add(18, "Program Early Termination").add(19, "Program Breakaway").add(20, "Program Resumption").add(21, "Program Runover Planned").add(22, "Program Runover Unplanned").add(23, "Program Overlap Start").add(24, "Program Blackout Override").add(25, "Program Start \u2013 In Progress").add(32, "Chapter Start").add(33, "Chapter End").add(34, "Break Start").add(35, "Break End").add(48, "Provider Advertisement Start").add(49, "Provider Advertisement End").add(50, "Distributor Advertisement Start").add(51, "Distributor Advertisement End").add(52, "Provider Placement Opportunity Start").add(53, "Provider Placement Opportunity End").add(54, "Distributor Placement Opportunity Start").add(55, "Distributor Placement Opportunity End").add(64, "Unscheduled Event Start").add(65, "Unscheduled Event End").add(80, "Network Start").add(81, "Network End").build();
    private byte[] segmentation_event_id;
    private int segmentation_event_cancel_indicator;
    private int reserved;
    private int program_segmentation_flag;
    private int segmentation_duration_flag;
    private int delivery_not_restricted_flag;
    private int web_delivery_allowed_flag;
    private int no_regional_blackout_flag;
    private int archive_allowed_flag;
    private int device_restrictions;
    private int reserved2;
    private int component_count;
    private List<ComponentOffset> componentOffsetList = new ArrayList<ComponentOffset>();
    private long segmentation_duration;
    private int segmentation_upid_type;
    private int segmentation_upid_length;
    private byte[] segmentation_upid;
    private int segmentation_type_id;
    private int segment_num;
    private int segments_expected;
    private int sub_segment_num;
    private int sub_segments_expected;

    public SegmentationDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.segmentation_event_id = Utils.getBytes(b, offset + 6, 4);
        this.segmentation_event_cancel_indicator = Utils.getInt(b, offset + 10, 1, 128) >> 7;
        this.reserved = Utils.getInt(b, offset + 10, 1, 127);
        if (this.segmentation_event_cancel_indicator == 0) {
            int localOffset = offset + 11;
            this.program_segmentation_flag = Utils.getInt(b, localOffset, 1, 128) >> 7;
            this.segmentation_duration_flag = Utils.getInt(b, localOffset, 1, 64) >> 6;
            this.delivery_not_restricted_flag = Utils.getInt(b, localOffset, 1, 32) >> 5;
            if (this.delivery_not_restricted_flag == 0) {
                this.web_delivery_allowed_flag = Utils.getInt(b, localOffset, 1, 16) >> 4;
                this.no_regional_blackout_flag = Utils.getInt(b, localOffset, 1, 8) >> 3;
                this.archive_allowed_flag = Utils.getInt(b, localOffset, 1, 4) >> 2;
                this.device_restrictions = Utils.getInt(b, localOffset, 1, 3);
            } else {
                this.reserved2 = Utils.getInt(b, localOffset, 1, 31);
            }
            ++localOffset;
            if (this.program_segmentation_flag == 0) {
                this.component_count = Utils.getInt(b, localOffset++, 1, 255);
                for (int i = 0; i < this.component_count; ++i) {
                    int component_tag = Utils.getInt(b, localOffset++, 1, 255);
                    int reserved = Utils.getInt(b, localOffset, 1, 254) >> 1;
                    long pts_offset = Utils.getLong(b, localOffset, 5, 0x1FFFFFFFFL);
                    ComponentOffset componentOffset = new ComponentOffset(this, component_tag, reserved, pts_offset);
                    this.componentOffsetList.add(componentOffset);
                    localOffset += 5;
                }
            }
            if (this.segmentation_duration_flag == 1) {
                this.segmentation_duration = Utils.getLong(b, localOffset, 5, 0xFFFFFFFFFFL);
                localOffset += 5;
            }
            this.segmentation_upid_type = Utils.getInt(b, localOffset++, 1, 255);
            this.segmentation_upid_length = Utils.getInt(b, localOffset++, 1, 255);
            if (this.segmentation_upid_length > 0) {
                this.segmentation_upid = Utils.getBytes(b, localOffset, this.segmentation_upid_length);
                localOffset += this.segmentation_upid_length;
            }
            this.segmentation_type_id = Utils.getInt(b, localOffset++, 1, 255);
            this.segment_num = Utils.getInt(b, localOffset++, 1, 255);
            this.segments_expected = Utils.getInt(b, localOffset++, 1, 255);
            if (this.segmentation_type_id == 52 || this.segmentation_type_id == 54) {
                this.sub_segment_num = Utils.getInt(b, localOffset++, 1, 255);
                this.sub_segments_expected = Utils.getInt(b, localOffset++, 1, 255);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("segmentation_event_id", this.segmentation_event_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("segmentation_event_cancel_indicator", this.segmentation_event_cancel_indicator, this.segmentation_event_cancel_indicator == 1 ? "a previously sent segmentation event has been cancelled" : "no previously sent segmentation event has been cancelled")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        if (this.segmentation_event_cancel_indicator == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("program_segmentation_flag", this.program_segmentation_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("segmentation_duration_flag", this.segmentation_duration_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("delivery_not_restricted_flag", this.delivery_not_restricted_flag, null)));
            if (this.delivery_not_restricted_flag == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("web_delivery_allowed_flag", this.web_delivery_allowed_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("no_regional_blackout_flag", this.no_regional_blackout_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("archive_allowed_flag", this.archive_allowed_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("device_restrictions", this.device_restrictions, null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
            }
            if (this.program_segmentation_flag == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("component_count", this.component_count, null)));
                Utils.addListJTree(t, this.componentOffsetList, modus, "Component Offsets");
            }
            if (this.segmentation_duration_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("segmentation_duration", this.segmentation_duration, Utils.printTimebase90kHz(this.segmentation_duration))));
            }
            t.add(new DefaultMutableTreeNode(new KVP("segmentation_upid_type", this.segmentation_upid_type, this.getSegmentationUpidTypeString(this.segmentation_upid_type))));
            t.add(new DefaultMutableTreeNode(new KVP("segmentation_upid_length", this.segmentation_upid_length, null)));
            if (this.segmentation_upid_length > 0) {
                t.add(new DefaultMutableTreeNode(new KVP("segmentation_upid", this.segmentation_upid, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("segmentation_type_id", this.segmentation_type_id, this.getSegmentationTypeIdString(this.segmentation_type_id))));
            t.add(new DefaultMutableTreeNode(new KVP("segment_num", this.segment_num, null)));
            t.add(new DefaultMutableTreeNode(new KVP("segments_expected", this.segments_expected, null)));
            if (this.segmentation_type_id == 52 || this.segmentation_type_id == 54) {
                t.add(new DefaultMutableTreeNode(new KVP("sub_segment_num", this.sub_segment_num, null)));
                t.add(new DefaultMutableTreeNode(new KVP("sub_segments_expected", this.sub_segments_expected, null)));
            }
        }
        return t;
    }

    private String getSegmentationUpidTypeString(int segmentation_upid_type) {
        return this.segmentationUpidTypeList.get(segmentation_upid_type);
    }

    private String getSegmentationTypeIdString(int segmentation_type_id) {
        return this.segmentationTypeIdList.get(segmentation_type_id);
    }

    public class ComponentOffset
    implements TreeNode {
        private int component_tag;
        private int reserved;
        private long pts_offset;

        public ComponentOffset(SegmentationDescriptor this$0, int component_tag, int reserved, long pts_offset) {
            this.component_tag = component_tag;
            this.reserved = reserved;
            this.pts_offset = pts_offset;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("component_offset"));
            t.add(new DefaultMutableTreeNode(new KVP("component_tag", this.component_tag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            t.add(new DefaultMutableTreeNode(new KVP("pts_offset", this.pts_offset, null)));
            return t;
        }
    }
}

