/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.Utils;

public class CompatibilityDescriptor
implements TreeNode {
    private final int compatibilityDescriptorLength;
    private int compatibilityDescriptorCount;
    private final List<CompDescriptor> descriptors = new ArrayList<CompDescriptor>();

    public CompatibilityDescriptor(byte[] data, int offset) {
        this.compatibilityDescriptorLength = Utils.getInt(data, offset, 2, 65535);
        if (this.compatibilityDescriptorLength > 0) {
            this.compatibilityDescriptorCount = Utils.getInt(data, offset + 2, 2, 65535);
            int t = offset + 4;
            for (int i = 0; i < this.compatibilityDescriptorCount; ++i) {
                int descriptorType = Utils.getInt(data, t, 1, 255);
                int descriptorLength = Utils.getInt(data, t + 1, 1, 255);
                int specifierType = Utils.getInt(data, t + 2, 1, 255);
                int specifierData = Utils.getInt(data, t + 3, 3, 0xFFFFFF);
                int model = Utils.getInt(data, t + 6, 2, 65535);
                int version = Utils.getInt(data, t + 8, 2, 65535);
                int subDescriptorCount = Utils.getInt(data, t + 10, 1, 255);
                t += 11;
                ArrayList<SubDescriptor> subDescriptors = new ArrayList<SubDescriptor>();
                for (int j = 0; j < subDescriptorCount; ++j) {
                    int subDescriptorType = Utils.getInt(data, t, 1, 255);
                    int subDescriptorLength = Utils.getInt(data, t + 1, 1, 255);
                    byte[] additionalInformation = Utils.copyOfRange(data, t + 2, t + 2 + subDescriptorLength);
                    SubDescriptor subDesc = new SubDescriptor(subDescriptorType, subDescriptorLength, additionalInformation);
                    subDescriptors.add(subDesc);
                    t += 2 + subDescriptorLength;
                }
                this.descriptors.add(new CompDescriptor(descriptorType, descriptorLength, specifierType, specifierData, model, version, subDescriptorCount, subDescriptors));
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t;
        if (this.compatibilityDescriptorLength > 0) {
            t = new DefaultMutableTreeNode(new KVP("CompatibilityDescriptor"));
            t.add(new DefaultMutableTreeNode(new KVP("compatibily_descriptor_length", this.compatibilityDescriptorLength, null)));
            t.add(new DefaultMutableTreeNode(new KVP("compatibily_descriptor_count", this.compatibilityDescriptorCount, null)));
            Utils.addListJTree(t, this.descriptors, modus, "descriptors");
        } else {
            t = new DefaultMutableTreeNode(new KVP("compatibily_descriptor_length", this.compatibilityDescriptorLength, null));
        }
        return t;
    }

    public static String getDescriptorTypeString(int t) {
        if (t >= 3 && t <= 63) {
            return "ISO/IEC 13818-6 reserved";
        }
        if (t >= 64 && t <= 127) {
            return "DVB reserved";
        }
        switch (t) {
            case 0: {
                return "Pad descriptor";
            }
            case 1: {
                return "System Hardware descriptor";
            }
            case 2: {
                return "System Software descriptor";
            }
        }
        return "User defined";
    }

    public int getCompatibilityDescriptorCount() {
        return this.compatibilityDescriptorCount;
    }

    public int getCompatibilityDescriptorLength() {
        return this.compatibilityDescriptorLength;
    }

    public List<CompDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public static class SubDescriptor
    implements TreeNode {
        private final int subDescriptorType;
        private final int subDescriptorLength;
        private final byte[] additionalInformation;

        public SubDescriptor(int subDescriptorType, int subDescriptorLength, byte[] additionalInformation) {
            this.subDescriptorType = subDescriptorType;
            this.subDescriptorLength = subDescriptorLength;
            this.additionalInformation = additionalInformation;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("SubDescriptor"));
            t.add(new DefaultMutableTreeNode(new KVP("subDescriptorType", this.subDescriptorType, null)));
            t.add(new DefaultMutableTreeNode(new KVP("subDescriptorLength", this.subDescriptorLength, null)));
            t.add(new DefaultMutableTreeNode(new KVP("additionalInformation", this.additionalInformation, null)));
            return t;
        }
    }

    public static class CompDescriptor
    implements TreeNode {
        private final int descriptorType;
        private final int descriptorLength;
        private final int specifierType;
        private final int specifierData;
        private final int model;
        private final int version;
        private final int subDescriptorCount;
        private List<SubDescriptor> subDescriptors = new ArrayList<SubDescriptor>();

        public CompDescriptor(int descriptorType, int descriptorLength, int specifierType, int specifierData, int model, int version, int subDescriptorCount, List<SubDescriptor> subDescriptors) {
            this.descriptorType = descriptorType;
            this.descriptorLength = descriptorLength;
            this.specifierType = specifierType;
            this.specifierData = specifierData;
            this.model = model;
            this.version = version;
            this.subDescriptorCount = subDescriptorCount;
            this.subDescriptors = subDescriptors;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Descriptor: " + CompatibilityDescriptor.getDescriptorTypeString(this.descriptorType)));
            t.add(new DefaultMutableTreeNode(new KVP("descriptorType", this.descriptorType, CompatibilityDescriptor.getDescriptorTypeString(this.descriptorType))));
            t.add(new DefaultMutableTreeNode(new KVP("descriptorLength", this.descriptorLength, null)));
            t.add(new DefaultMutableTreeNode(new KVP("specifierType", this.specifierType, CompDescriptor.getSpecifierTypeString(this.specifierType))));
            t.add(new DefaultMutableTreeNode(new KVP("specifierData", this.specifierData, this.specifierType == 1 ? Utils.getOUIString(this.specifierData) : null)));
            t.add(new DefaultMutableTreeNode(new KVP("model", this.model, null)));
            t.add(new DefaultMutableTreeNode(new KVP("version", this.version, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sub_descriptor_count", this.subDescriptorCount, null)));
            Utils.addListJTree(t, this.subDescriptors, modus, "SubDescriptors");
            return t;
        }

        private static String getSpecifierTypeString(int specifierType2) {
            if (specifierType2 == 0) {
                return "ISO/IEC 13818-6 reserved";
            }
            if (specifierType2 == 1) {
                return "IEEE OUI.";
            }
            if (specifierType2 >= 2 && specifierType2 <= 127) {
                return "ISO/IEC 13818-6 reserved";
            }
            return "User Defined";
        }
    }
}

