/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SchedulingDescriptor
extends UNTDescriptor {
    private final byte[] start_date_time;
    private final byte[] end_date_time;
    private final int final_availability;
    private final int periodicity_flag;
    private final int period_unit;
    private final int duration_unit;
    private final int estimated_cycle_time_unit;
    private final int period;
    private final int duration;
    private final int estimated_cycle_time;
    private final byte[] privateDataByte;

    public SchedulingDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.start_date_time = Utils.copyOfRange(b, offset + 2, offset + 7);
        this.end_date_time = Utils.copyOfRange(b, offset + 7, offset + 12);
        this.final_availability = Utils.getInt(b, offset + 12, 1, 128) >> 7;
        this.periodicity_flag = Utils.getInt(b, offset + 12, 1, 64) >> 6;
        this.period_unit = Utils.getInt(b, offset + 12, 1, 48) >> 4;
        this.duration_unit = Utils.getInt(b, offset + 12, 1, 12) >> 2;
        this.estimated_cycle_time_unit = Utils.getInt(b, offset + 12, 1, 3);
        this.period = Utils.getInt(b, offset + 13, 1, 255);
        this.duration = Utils.getInt(b, offset + 14, 1, 255);
        this.estimated_cycle_time = Utils.getInt(b, offset + 15, 1, 255);
        this.privateDataByte = Utils.copyOfRange(b, offset + 16, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("start_date_time", this.start_date_time, Utils.getUTCFormattedString(this.start_date_time))));
        t.add(new DefaultMutableTreeNode(new KVP("end_date_time", this.end_date_time, Utils.getUTCFormattedString(this.end_date_time))));
        t.add(new DefaultMutableTreeNode(new KVP("final_availability", this.final_availability, null)));
        t.add(new DefaultMutableTreeNode(new KVP("periodicity_flag", this.periodicity_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("period_unit", this.period_unit, SchedulingDescriptor.getTimeUnitsCodingString(this.period_unit))));
        t.add(new DefaultMutableTreeNode(new KVP("duration_unit", this.duration_unit, SchedulingDescriptor.getTimeUnitsCodingString(this.duration_unit))));
        t.add(new DefaultMutableTreeNode(new KVP("estimated_cycle_time_unit", this.estimated_cycle_time_unit, SchedulingDescriptor.getTimeUnitsCodingString(this.estimated_cycle_time_unit))));
        t.add(new DefaultMutableTreeNode(new KVP("period", this.period, null)));
        t.add(new DefaultMutableTreeNode(new KVP("duration", this.duration, null)));
        t.add(new DefaultMutableTreeNode(new KVP("estimated_cycle_time", this.estimated_cycle_time, null)));
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        return t;
    }

    public static String getTimeUnitsCodingString(int t) {
        switch (t) {
            case 0: {
                return "Second";
            }
            case 1: {
                return "Minute";
            }
            case 2: {
                return "Hour";
            }
            case 3: {
                return "Day";
            }
        }
        return "illegal value";
    }
}

