/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TargetSmartcardDescriptor
extends UNTDescriptor {
    private final int super_CA_system_id;
    private final byte[] privateDataByte;

    public TargetSmartcardDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.super_CA_system_id = Utils.getInt(b, offset + 2, 4, -1);
        this.privateDataByte = Utils.copyOfRange(b, offset + 6, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        DefaultMutableTreeNode super_CA_system_idNode = new DefaultMutableTreeNode(new KVP("super_CA_system_id", this.super_CA_system_id, null));
        int caSystemID = this.super_CA_system_id >>> 16;
        int caSubsystem_id = this.super_CA_system_id & 0xFFFF;
        super_CA_system_idNode.add(new DefaultMutableTreeNode(new KVP("CA_system_id", caSystemID, Utils.getCASystemIDString(caSystemID))));
        super_CA_system_idNode.add(new DefaultMutableTreeNode(new KVP("CA_subsystem_id", caSubsystem_id, null)));
        t.add(super_CA_system_idNode);
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        return t;
    }
}

