/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class UpdateDescriptor
extends UNTDescriptor {
    private final int update_flag;
    private final int update_method;
    private final int update_priority;
    private final byte[] privateDataByte;

    public UpdateDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.update_flag = Utils.getInt(b, offset + 2, 1, 192) >> 6;
        this.update_method = Utils.getInt(b, offset + 2, 1, 60) >> 2;
        this.update_priority = Utils.getInt(b, offset + 2, 1, 3);
        this.privateDataByte = Utils.copyOfRange(b, offset + 3, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("update_flag", this.update_flag, UpdateDescriptor.getUpdateFlagString(this.update_flag))));
        t.add(new DefaultMutableTreeNode(new KVP("update_method", this.update_method, UpdateDescriptor.getUpdateMethodString(this.update_method))));
        t.add(new DefaultMutableTreeNode(new KVP("update_priority", this.update_priority, null)));
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        return t;
    }

    public static String getUpdateFlagString(int t) {
        switch (t) {
            case 0: {
                return "The update has to be activated manually";
            }
            case 1: {
                return "The update may be performed automatically";
            }
            case 2: {
                return "Reserved for future use";
            }
            case 3: {
                return "Reserved for future use";
            }
        }
        return "illegal value";
    }

    public static String getUpdateMethodString(int t) {
        if (t >= 3 && t <= 7) {
            return "reserved for future use";
        }
        switch (t) {
            case 0: {
                return "immediate update: performed whatever the IRD state";
            }
            case 1: {
                return "IRD available: the update is available in the stream; it will be taken into account when it does not interfere with the normal user operation";
            }
            case 2: {
                return "next restart: the update is available in the stream; it will be taken into account at the next IRD restart";
            }
            case 15: {
                return "reserved";
            }
        }
        return "private use";
    }
}

