/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPMessage;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPFileMessage
extends BIOPMessage {
    protected byte[] objectInfo_data_byte = new byte[0];
    protected int serviceContextList_count;
    private final List<ServiceContext> serviceContextList = new ArrayList<ServiceContext>();
    protected long messageBody_length;
    private byte[] dsmFileContentSize;
    private final long content_length;
    private final int contentStartOffset;

    public BIOPFileMessage(byte[] data, int offset) {
        super(data, offset);
        if (this.objectInfo_length >= 8) {
            this.dsmFileContentSize = Arrays.copyOfRange(data, this.byte_counter, this.byte_counter + 8);
        }
        if (this.objectInfo_length > 8) {
            this.objectInfo_data_byte = Arrays.copyOfRange(data, this.byte_counter + 8, this.byte_counter + this.objectInfo_length);
        }
        this.byte_counter += this.objectInfo_length;
        this.serviceContextList_count = Utils.getInt(data, this.byte_counter, 1, 255);
        ++this.byte_counter;
        for (int i = 0; i < this.serviceContextList_count; ++i) {
            long context_id = Utils.getLong(data, this.byte_counter, 4, -1L);
            this.byte_counter += 4;
            int context_data_length = Utils.getInt(data, this.byte_counter, 2, 65535);
            this.byte_counter += 2;
            byte[] context_data_byte = Arrays.copyOfRange(data, this.byte_counter, this.byte_counter + context_data_length);
            this.byte_counter += context_data_length;
            ServiceContext serviceContext = new ServiceContext(context_id, context_data_length, context_data_byte);
            this.serviceContextList.add(serviceContext);
        }
        this.messageBody_length = Utils.getLong(data, this.byte_counter, 4, -1L);
        this.byte_counter += 4;
        this.content_length = Utils.getLong(data, this.byte_counter, 4, -1L);
        this.byte_counter += 4;
        this.contentStartOffset = this.byte_counter;
    }

    @Override
    public KVP getJTreeNode(int modus, String label) {
        KVP t = super.getJTreeNode(modus, label);
        t.add(new KVP("dsmFileContentSize", this.dsmFileContentSize));
        t.add(new KVP("objectInfo_data_byte", this.objectInfo_data_byte));
        t.add(new KVP("serviceContextList_count", this.serviceContextList_count));
        Utils.addListJTree(t, this.serviceContextList, modus, "ServiceContextList");
        t.add(new KVP("messageBody_length", this.messageBody_length));
        t.add(new KVP("content_length", this.content_length));
        t.add(new KVP("content_data_byte", this.data, this.contentStartOffset, (int)this.content_length));
        return t;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return this.getJTreeNode(modus, "");
    }

    public byte[] getObjectInfo_data_byte() {
        return this.objectInfo_data_byte;
    }

    public int getServiceContextList_count() {
        return this.serviceContextList_count;
    }

    public List<ServiceContext> getServiceContextList() {
        return this.serviceContextList;
    }

    public long getMessageBody_length() {
        return this.messageBody_length;
    }

    public byte[] getDsmFileContentSize() {
        return this.dsmFileContentSize;
    }

    public long getContent_length() {
        return this.content_length;
    }

    public int getContentStartOffset() {
        return this.contentStartOffset;
    }

    public static class ServiceContext
    implements TreeNode {
        private final long context_id;
        private final int context_data_length;
        private final byte[] context_data_byte;

        public ServiceContext(long context_id, int context_data_length, byte[] context_data_byte) {
            this.context_id = context_id;
            this.context_data_length = context_data_length;
            this.context_data_byte = context_data_byte;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("ServiceContext");
            t.add(new KVP("context_id", this.context_id));
            t.add(new KVP("context_data_length", this.context_data_length));
            t.add(new KVP("context_data_byte", this.context_data_byte));
            return t;
        }
    }
}

