/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.IOR;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPMessage
implements TreeNode {
    protected byte[] data;
    protected int offset;
    protected byte[] magic;
    protected int biop_version_major;
    protected int biop_version_minor;
    protected int byte_order;
    protected int message_type;
    protected long message_size;
    protected int objectKey_length;
    protected byte[] objectKey_data_byte;
    protected long objectKind_length;
    protected byte[] objectKind_data;
    protected int objectInfo_length;
    protected int byte_counter;

    public BIOPMessage(byte[] data, int off) {
        this.data = data;
        this.offset = off;
        this.magic = Arrays.copyOfRange(data, this.offset, this.offset + 4);
        this.biop_version_major = Utils.getInt(data, this.offset + 4, 1, 255);
        this.biop_version_minor = Utils.getInt(data, this.offset + 5, 1, 255);
        this.byte_order = Utils.getInt(data, this.offset + 6, 1, 255);
        this.message_type = Utils.getInt(data, this.offset + 7, 1, 255);
        this.message_size = Utils.getLong(data, this.offset + 8, 4, -1L);
        this.objectKey_length = Utils.getInt(data, this.offset + 12, 1, 255);
        this.objectKey_data_byte = Arrays.copyOfRange(data, this.offset + 13, this.offset + 13 + this.objectKey_length);
        this.byte_counter = this.offset + 13 + this.objectKey_length;
        this.objectKind_length = 4L;
        this.byte_counter += 4;
        this.objectKind_data = Arrays.copyOfRange(data, this.byte_counter, this.byte_counter + (int)this.objectKind_length);
        this.byte_counter = (int)((long)this.byte_counter + this.objectKind_length);
        this.objectInfo_length = Utils.getInt(data, this.byte_counter, 2, 65535);
        this.byte_counter += 2;
    }

    public KVP getJTreeNode(int modus, String label) {
        KVP t = new KVP(IOR.getTypeIdString(this.objectKind_data), label);
        t.add(new KVP("magic", this.magic));
        t.add(new KVP("biop_version_major", this.biop_version_major));
        t.add(new KVP("biop_version_minor", this.biop_version_minor));
        t.add(new KVP("byte_order", this.byte_order));
        t.add(new KVP("message_type", this.message_type));
        t.add(new KVP("message_size", this.message_size));
        t.add(new KVP("objectKey_length", this.objectKey_length));
        t.add(new KVP("objectKey_data_byte", this.objectKey_data_byte));
        t.add(new KVP("objectKind_length", this.objectKind_length));
        t.add(new KVP("objectKind_data", this.objectKind_data));
        t.add(new KVP("objectInfo_length", this.objectInfo_length));
        return t;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return this.getJTreeNode(modus, "");
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public int getBiop_version_major() {
        return this.biop_version_major;
    }

    public int getBiop_version_minor() {
        return this.biop_version_minor;
    }

    public int getByte_order() {
        return this.byte_order;
    }

    public int getMessage_type() {
        return this.message_type;
    }

    public long getMessage_size() {
        return this.message_size;
    }

    public int getObjectKey_length() {
        return this.objectKey_length;
    }

    public byte[] getObjectKey_data_byte() {
        return this.objectKey_data_byte;
    }

    public long getObjectKind_length() {
        return this.objectKind_length;
    }

    public byte[] getObjectKind_data() {
        return this.objectKind_data;
    }

    public int getObjectInfo_length() {
        return this.objectInfo_length;
    }
}

