/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.LiteComponent;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPObjectLocation
extends LiteComponent {
    protected long carouselId;
    protected int moduleId;
    protected int version_major;
    protected int version_minor;
    protected int objectKey_length;
    protected byte[] objectKey_data_byte;

    public BIOPObjectLocation(byte[] data, int offset) {
        super(data, offset);
        this.carouselId = Utils.getLong(data, offset + 5, 4, -1L);
        this.moduleId = Utils.getInt(data, offset + 9, 2, 65535);
        this.version_major = Utils.getInt(data, offset + 11, 1, 255);
        this.version_minor = Utils.getInt(data, offset + 12, 1, 255);
        this.objectKey_length = Utils.getInt(data, offset + 13, 1, 255);
        this.objectKey_data_byte = Arrays.copyOfRange(data, offset + 14, offset + 14 + this.objectKey_length);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("BIOP::ObjectLocation");
        t.add(new KVP("component_tag", this.component_tag, BIOPObjectLocation.getComponentTagString((int)this.component_tag)));
        t.add(new KVP("component_data_length", this.component_data_length));
        t.add(new KVP("carouselId", this.carouselId));
        t.add(new KVP("moduleId", this.moduleId));
        t.add(new KVP("version.major", this.version_major));
        t.add(new KVP("version.minor", this.version_minor));
        t.add(new KVP("objectKey_length", this.objectKey_length));
        t.add(new KVP("objectKey_data_byte", this.objectKey_data_byte));
        return t;
    }

    public long getCarouselId() {
        return this.carouselId;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getVersion_major() {
        return this.version_major;
    }

    public int getVersion_minor() {
        return this.version_minor;
    }

    public int getObjectKey_length() {
        return this.objectKey_length;
    }

    public byte[] getObjectKey_data_byte() {
        return this.objectKey_data_byte;
    }
}

