/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPMessage;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPName;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.IOR;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.Tap;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPStreamEventMessage
extends BIOPMessage {
    protected byte[] objectInfo_data_byte;
    protected int serviceContextList_count;
    private final List<ServiceContext> serviceContextList = new ArrayList<ServiceContext>();
    protected long messageBody_length;
    protected int bindings_count;
    private final List<Binding> bindingList = new ArrayList<Binding>();
    private final int aDescription_length;
    private final byte[] aDescription_bytes;
    private final long duration_aSeconds;
    private final long duration_aMicroSeconds;
    private final int audio;
    private final int video;
    private final int data1;
    private final int eventNames_count;
    private final List<EventName> eventNames = new ArrayList<EventName>();
    private final int taps_count;
    private final List<Tap> taps = new ArrayList<Tap>();
    private final int eventIds_count;
    private final List<EventId> eventIds = new ArrayList<EventId>();

    public BIOPStreamEventMessage(byte[] dataBytes, int offset) {
        super(dataBytes, offset);
        int i;
        int objectInfoStart = this.byte_counter;
        this.aDescription_length = Utils.getInt(dataBytes, this.byte_counter, 1, 255);
        ++this.byte_counter;
        this.aDescription_bytes = Arrays.copyOfRange(dataBytes, this.byte_counter, this.byte_counter + this.aDescription_length);
        this.byte_counter += this.aDescription_length;
        this.duration_aSeconds = Utils.getLong(dataBytes, this.byte_counter, 4, -1L);
        this.byte_counter += 4;
        this.duration_aMicroSeconds = Utils.getLong(dataBytes, this.byte_counter, 4, -1L);
        this.byte_counter += 4;
        this.audio = Utils.getInt(dataBytes, this.byte_counter, 1, 255);
        ++this.byte_counter;
        this.video = Utils.getInt(dataBytes, this.byte_counter, 1, 255);
        ++this.byte_counter;
        this.data1 = Utils.getInt(dataBytes, this.byte_counter, 1, 255);
        ++this.byte_counter;
        this.eventNames_count = Utils.getInt(dataBytes, this.byte_counter, 2, 65535);
        this.byte_counter += 2;
        for (i = 0; i < this.eventNames_count; ++i) {
            int eventName_length = Utils.getInt(dataBytes, this.byte_counter, 1, 255);
            ++this.byte_counter;
            byte[] eventName_data_byte = Arrays.copyOfRange(dataBytes, this.byte_counter, this.byte_counter + eventName_length);
            this.byte_counter += eventName_length;
            EventName eventName = new EventName(eventName_length, eventName_data_byte);
            this.eventNames.add(eventName);
        }
        this.objectInfo_data_byte = Arrays.copyOfRange(dataBytes, this.byte_counter, objectInfoStart + this.objectInfo_length);
        this.byte_counter = objectInfoStart + this.objectInfo_length;
        this.serviceContextList_count = Utils.getInt(this.data, this.byte_counter, 1, 255);
        ++this.byte_counter;
        for (i = 0; i < this.serviceContextList_count; ++i) {
            long context_id = Utils.getLong(this.data, this.byte_counter, 4, -1L);
            this.byte_counter += 4;
            int context_data_length = Utils.getInt(this.data, this.byte_counter, 2, 65535);
            this.byte_counter += 2;
            byte[] context_data_byte = Arrays.copyOfRange(this.data, this.byte_counter, this.byte_counter + context_data_length);
            this.byte_counter += context_data_length;
            ServiceContext serviceContext = new ServiceContext(context_id, context_data_length, context_data_byte);
            this.serviceContextList.add(serviceContext);
        }
        this.messageBody_length = Utils.getLong(this.data, this.byte_counter, 4, -1L);
        this.byte_counter += 4;
        this.taps_count = Utils.getInt(this.data, this.byte_counter, 1, 255);
        ++this.byte_counter;
        for (i = 0; i < this.taps_count; ++i) {
            Tap tap = new Tap(this.data, this.byte_counter);
            this.taps.add(tap);
            this.byte_counter += tap.getSelector_length() + 7;
        }
        this.eventIds_count = Utils.getInt(this.data, this.byte_counter, 1, 255);
        ++this.byte_counter;
        for (i = 0; i < this.eventIds_count; ++i) {
            EventId eventId = new EventId(Utils.getInt(this.data, this.byte_counter, 2, 65535));
            this.eventIds.add(eventId);
            this.byte_counter += 2;
        }
    }

    @Override
    public KVP getJTreeNode(int modus, String label) {
        KVP t = super.getJTreeNode(modus, label);
        t.add(new KVP("aDescription_length", this.aDescription_length));
        t.add(new KVP("aDescription_bytes", this.aDescription_bytes));
        t.add(new KVP("duration.aSeconds", this.duration_aSeconds));
        t.add(new KVP("duration.aMicroSeconds", this.duration_aMicroSeconds));
        t.add(new KVP("audio", this.audio));
        t.add(new KVP("video", this.video));
        t.add(new KVP("data", this.data1));
        t.add(new KVP("eventNames_count", this.eventNames_count));
        Utils.addListJTree(t, this.eventNames, modus, "EventNames");
        t.add(new KVP("objectInfo_data_byte", this.objectInfo_data_byte));
        t.add(new KVP("serviceContextList_count", this.serviceContextList_count));
        Utils.addListJTree(t, this.serviceContextList, modus, "ServiceContextList");
        t.add(new KVP("messageBody_length", this.messageBody_length));
        Utils.addListJTree(t, this.taps, modus, "BIOP::Taps");
        t.add(new KVP("eventIds_count", this.eventIds_count));
        Utils.addListJTree(t, this.eventIds, modus, "EventIds");
        return t;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return this.getJTreeNode(modus, "");
    }

    private static String getBindingTypeString(int bindingType) {
        if (bindingType == 1) {
            return "nobject";
        }
        if (bindingType == 2) {
            return "ncontext";
        }
        return null;
    }

    public byte[] getObjectInfo_data_byte() {
        return this.objectInfo_data_byte;
    }

    public int getServiceContextList_count() {
        return this.serviceContextList_count;
    }

    public List<ServiceContext> getServiceContextList() {
        return this.serviceContextList;
    }

    public long getMessageBody_length() {
        return this.messageBody_length;
    }

    public int getBindings_count() {
        return this.bindings_count;
    }

    public List<Binding> getBindingList() {
        return this.bindingList;
    }

    public long getDuration_aSeconds() {
        return this.duration_aSeconds;
    }

    public long getDuration_aMicroSeconds() {
        return this.duration_aMicroSeconds;
    }

    public int getAudio() {
        return this.audio;
    }

    public int getVideo() {
        return this.video;
    }

    public int getData1() {
        return this.data1;
    }

    public int getEventNames_count() {
        return this.eventNames_count;
    }

    public List<EventName> getEventNames() {
        return this.eventNames;
    }

    public int getTaps_count() {
        return this.taps_count;
    }

    public List<Tap> getTaps() {
        return this.taps;
    }

    public int getEventIds_count() {
        return this.eventIds_count;
    }

    public List<EventId> getEventIds() {
        return this.eventIds;
    }

    public record EventName(int eventName_length, byte[] eventName_data_byte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("EventName");
            t.add(new KVP("eventName_length", this.eventName_length));
            t.add(new KVP("eventName_data_byte", this.eventName_data_byte));
            return t;
        }
    }

    public record ServiceContext(long context_id, int context_data_length, byte[] context_data_byte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("ServiceContext");
            t.add(new KVP("context_id", this.context_id));
            t.add(new KVP("context_data_length", this.context_data_length));
            t.add(new KVP("context_data_byte", this.context_data_byte));
            return t;
        }
    }

    public record EventId(int eventId) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            return new KVP("eventId", this.eventId);
        }
    }

    public static class Binding
    implements TreeNode {
        private final BIOPName biopName;
        private final int bindingType;
        private final IOR ior;
        private final int objectInfo_length;
        private final byte[] objectInfo_data_byte;
        private int len = 0;

        public Binding(byte[] data, int offset) {
            this.biopName = new BIOPName(data, offset);
            this.len = this.biopName.getLen();
            this.bindingType = Utils.getInt(data, offset + this.len, 1, 255);
            ++this.len;
            this.ior = new IOR(data, offset + this.len);
            this.len += this.ior.getLength();
            this.objectInfo_length = Utils.getInt(data, offset + this.len, 2, 65535);
            this.len += 2;
            this.objectInfo_data_byte = Arrays.copyOfRange(data, offset + this.len, offset + this.len + this.objectInfo_length);
            this.len += this.objectInfo_length;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("Binding", this.biopName.getName());
            t.add(this.biopName.getJTreeNode(modus));
            t.add(new KVP("bindingType", this.bindingType, BIOPStreamEventMessage.getBindingTypeString(this.bindingType)));
            t.add(this.ior.getJTreeNode(modus));
            return t;
        }

        public int length() {
            return this.len;
        }

        public BIOPName getBiopName() {
            return this.biopName;
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public IOR getIor() {
            return this.ior;
        }

        public int getObjectInfo_length() {
            return this.objectInfo_length;
        }

        public byte[] getObjectInfo_data_byte() {
            return this.objectInfo_data_byte;
        }

        public int getLen() {
            return this.len;
        }
    }
}

