/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;

public class DSMCC_DownLoadDataMessageSection
extends TableSectionExtendedSyntax {
    private final DSMCCMessageHeader header;
    private final int moduleId;
    private final int moduleVersion;
    private final int reserved;
    private final int blockNumber;
    private final byte[] blockDataByte;

    public DSMCC_DownLoadDataMessageSection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        int protocolDiscriminator = Utils.getInt(raw_data.getData(), 8, 1, 255);
        int dsmccType = Utils.getInt(raw_data.getData(), 9, 1, 255);
        int messageId = Utils.getInt(raw_data.getData(), 10, 2, 65535);
        long downloadId = Utils.getLong(raw_data.getData(), 12, 4, -1L);
        int reserved1 = Utils.getInt(raw_data.getData(), 16, 1, 255);
        int adaptationLength = Utils.getInt(raw_data.getData(), 17, 1, 255);
        int messageLength = Utils.getInt(raw_data.getData(), 18, 2, 65535);
        this.header = new DSMCCMessageHeader(protocolDiscriminator, dsmccType, messageId, downloadId, reserved1, adaptationLength, messageLength);
        this.moduleId = Utils.getInt(raw_data.getData(), 20, 2, 65535);
        this.moduleVersion = Utils.getInt(raw_data.getData(), 22, 1, 255);
        this.reserved = Utils.getInt(raw_data.getData(), 23, 1, 255);
        this.blockNumber = Utils.getInt(raw_data.getData(), 24, 2, 65535);
        byte[] original = raw_data.getData();
        this.blockDataByte = Arrays.copyOfRange(original, 26, 20 + this.header.messageLength());
    }

    public int getPayLoadLength() {
        if (this.header != null) {
            return this.header.messageLength() - 6;
        }
        return 0;
    }

    public byte[] getPayLoad() {
        return Arrays.copyOfRange(this.raw_data.getData(), 26, 26 + this.header.messageLength() - 6);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("DSMCCsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(DSMCC_DownLoadDataMessageSection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.add(this.header.getJTreeNode(modus));
        t.add(new KVP("moduleId", this.moduleId));
        t.add(new KVP("moduleVersion", this.moduleVersion));
        t.add(new KVP("reserved", this.reserved));
        t.add(new KVP("blockNumber", this.blockNumber));
        t.add(new KVP("blockDataByte", this.blockDataByte));
        return t;
    }

    private static String getDSMCCTypeString(int dsmccType) {
        switch (dsmccType) {
            case 1: {
                return "User-to-Network configuration message";
            }
            case 2: {
                return "User-to-Network session message";
            }
            case 3: {
                return "Download message";
            }
            case 4: {
                return "SDB Channel Change Protocol message";
            }
            case 5: {
                return "User-to- Network pass-thru message";
            }
        }
        if (dsmccType >= 128 && dsmccType <= 255) {
            return "User Defined message type";
        }
        return "reserved";
    }

    private static String getMessageIDString(int dsmccType, int messageId) {
        return switch (dsmccType) {
            case 3 -> {
                switch (messageId) {
                    case 4097: {
                        yield "DownloadInfoRequest";
                    }
                    case 4098: {
                        yield "DownloadInfoIndication";
                    }
                    case 4099: {
                        yield "DownloadDataBlock";
                    }
                    case 4100: {
                        yield "DownloadDataRequest";
                    }
                    case 4101: {
                        yield "DownloadCancel";
                    }
                    case 4102: {
                        yield "DownloadServerInitiate";
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    public DSMCCMessageHeader getHeader() {
        return this.header;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getModuleVersion() {
        return this.moduleVersion;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public byte[] getBlockDataByte() {
        return this.blockDataByte;
    }

    public record DSMCCMessageHeader(int protocolDiscriminator, int dsmccType, int messageId, long downloadId, int reserved, int adaptationLength, int messageLength) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("DSM-CC Message Header");
            t.add(new KVP("protocolDiscriminator", this.protocolDiscriminator));
            t.add(new KVP("dsmccType", this.dsmccType, DSMCC_DownLoadDataMessageSection.getDSMCCTypeString(this.dsmccType)));
            t.add(new KVP("messageId", this.messageId, DSMCC_DownLoadDataMessageSection.getMessageIDString(this.dsmccType, this.messageId)));
            t.add(new KVP("downloadId", this.downloadId));
            t.add(new KVP("reserved", this.reserved));
            t.add(new KVP("adaptationLength", this.adaptationLength));
            t.add(new KVP("messageLength", this.messageLength));
            return t;
        }
    }
}

