/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.DSMCCDescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.CompatibilityDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPModuleInfo;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.IOR;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;

public class DSMCC_UNMessageSection
extends TableSectionExtendedSyntax {
    private boolean isObjectCarousel = true;
    private final DSMCCMessageHeader header;
    private byte[] serverId;
    private CompatibilityDescriptor compatibilityDescriptor;
    private int privateDataLength;
    private byte[] privateDataByte;
    private IOR serviceGatewayIOR;
    private int downloadTaps_count;
    private int serviceContextList_count;
    private int userInfoLength;
    private final List<GroupInfo> groupInfoIndication = new ArrayList<GroupInfo>();
    private long downloadId;
    private int blockSize;
    private int windowSize;
    private int ackPeriod;
    private long tCDownloadWindow;
    private long tCDownloadScenario;
    private int numberOfModules;
    private final List<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private int numberOfGroups;
    private int groupInfoLength;
    private byte[] groupInfoByte;
    private int privateDataLen2;
    private byte[] privateDataByte2;

    public DSMCC_UNMessageSection(PsiSectionData raw_data, PID parent, boolean isObjectCarousel2) {
        super(raw_data, parent);
        this.isObjectCarousel = isObjectCarousel2;
        int protocolDiscriminator = Utils.getInt(raw_data.getData(), 8, 1, 255);
        int dsmccType = Utils.getInt(raw_data.getData(), 9, 1, 255);
        int messageId = Utils.getInt(raw_data.getData(), 10, 2, 65535);
        long transactionId = Utils.getLong(raw_data.getData(), 12, 4, -1L);
        int reserved = Utils.getInt(raw_data.getData(), 16, 1, 255);
        int adaptationLength = Utils.getInt(raw_data.getData(), 17, 1, 255);
        int messageLength = Utils.getInt(raw_data.getData(), 18, 2, 65535);
        this.header = new DSMCCMessageHeader(protocolDiscriminator, dsmccType, messageId, transactionId, reserved, adaptationLength, messageLength);
        if (messageId == 4102) {
            this.serverId = Arrays.copyOfRange(raw_data.getData(), 20, 40);
            this.compatibilityDescriptor = new CompatibilityDescriptor(raw_data.getData(), 40);
            int offs = 42 + this.compatibilityDescriptor.getCompatibilityDescriptorLength();
            this.privateDataLength = Utils.getInt(raw_data.getData(), offs, 2, 65535);
            this.privateDataByte = Arrays.copyOfRange(raw_data.getData(), offs += 2, offs + this.privateDataLength);
            if (this.isObjectCarousel) {
                this.serviceGatewayIOR = new IOR(this.privateDataByte, 0);
                int len = this.serviceGatewayIOR.getLength();
                this.downloadTaps_count = Utils.getInt(this.privateDataByte, len, 1, 255);
                this.serviceContextList_count = Utils.getInt(this.privateDataByte, len + 1, 1, 255);
                this.userInfoLength = Utils.getInt(this.privateDataByte, len + 2, 2, 65535);
            } else {
                int offset = 0;
                this.numberOfGroups = Utils.getInt(this.privateDataByte, offset, 2, 65535);
                offset += 2;
                for (int i = 0; i < this.numberOfGroups; ++i) {
                    GroupInfo groupInfo = new GroupInfo(this.privateDataByte, offset);
                    this.groupInfoIndication.add(groupInfo);
                    offset += groupInfo.len();
                }
                this.groupInfoLength = Utils.getInt(this.privateDataByte, offset, 2, 65535);
                this.groupInfoByte = Utils.getBytes(this.privateDataByte, offset += 2, this.groupInfoLength);
                this.privateDataLen2 = Utils.getInt(this.privateDataByte, offset += this.groupInfoLength, 2, 65535);
                this.privateDataByte2 = Utils.getBytes(this.privateDataByte, offset += 2, this.privateDataLen2);
                offset += this.privateDataLen2;
            }
        } else if (messageId == 4098) {
            this.downloadId = Utils.getLong(raw_data.getData(), 20, 4, -1L);
            this.blockSize = Utils.getInt(raw_data.getData(), 24, 2, 65535);
            this.windowSize = Utils.getInt(raw_data.getData(), 26, 1, 255);
            this.ackPeriod = Utils.getInt(raw_data.getData(), 27, 1, 255);
            this.tCDownloadWindow = Utils.getLong(raw_data.getData(), 28, 4, -1L);
            this.tCDownloadScenario = Utils.getLong(raw_data.getData(), 32, 4, -1L);
            this.compatibilityDescriptor = new CompatibilityDescriptor(raw_data.getData(), 36);
            int p = 38 + this.compatibilityDescriptor.getCompatibilityDescriptorLength();
            this.numberOfModules = Utils.getInt(raw_data.getData(), p, 2, 65535);
            p += 2;
            for (int i = 0; i < this.numberOfModules; ++i) {
                int moduleId = Utils.getInt(raw_data.getData(), p, 2, 65535);
                long moduleSize = Utils.getLong(raw_data.getData(), p += 2, 4, -1L);
                p += 4;
                int moduleVersion = Utils.getInt(raw_data.getData(), p++, 1, 255);
                int moduleInfoLength = Utils.getInt(raw_data.getData(), p++, 1, 255);
                byte[] moduleInfoByte = Utils.getBytes(raw_data.getData(), p, moduleInfoLength);
                p += moduleInfoLength;
                ModuleInfo mod = new ModuleInfo(moduleId, moduleSize, moduleVersion, moduleInfoLength, moduleInfoByte);
                this.modules.add(mod);
            }
            this.privateDataLength = Utils.getInt(raw_data.getData(), p, 2, 65535);
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("DSMCCsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(DSMCC_UNMessageSection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.setUserObject(new KVP(this.isDSI() ? "DSI" : "DII"));
        t.add(this.header.getJTreeNode(modus));
        if (this.isDSI()) {
            t.add(new KVP("serverId", this.serverId));
            t.add(this.compatibilityDescriptor.getJTreeNode(modus));
            t.add(new KVP("privateDataLength", this.privateDataLength));
            t.add(new KVP("privateDataByte", this.privateDataByte));
            if (this.isObjectCarousel) {
                t.add(this.serviceGatewayIOR.getJTreeNode(modus));
                t.add(new KVP("downloadTaps_count", this.downloadTaps_count));
                t.add(new KVP("serviceContextList_count", this.serviceContextList_count));
                t.add(new KVP("userInfoLength", this.userInfoLength));
            } else {
                t.add(new KVP("numberOfGroups", this.numberOfGroups));
                Utils.addListJTree(t, this.groupInfoIndication, modus, "GroupInfos");
                t.add(new KVP("groupInfoLength", this.groupInfoLength));
                t.add(new KVP("groupInfoByte", this.groupInfoByte));
                t.add(new KVP("privateDataLen", this.privateDataLen2));
                t.add(new KVP("privateDataByte", this.privateDataByte2));
            }
        } else if (this.isDII()) {
            t.add(new KVP("downloadId", this.downloadId));
            t.add(new KVP("blockSize", this.blockSize));
            t.add(new KVP("windowSize", this.windowSize));
            t.add(new KVP("ackPeriod", this.ackPeriod));
            t.add(new KVP("tCDownloadWindow", this.tCDownloadWindow));
            t.add(new KVP("tCDownloadScenario", this.tCDownloadScenario));
            t.add(this.compatibilityDescriptor.getJTreeNode(modus));
            t.add(new KVP("numberOfModules", this.numberOfModules));
            Utils.addListJTree(t, this.modules, modus, "Modules");
            t.add(new KVP("privateDataLength", this.privateDataLength));
        }
        return t;
    }

    public boolean isDII() {
        return this.header.getMessageId() == 4098;
    }

    public boolean isDSI() {
        return this.header.getMessageId() == 4102;
    }

    private static String getDSMCCTypeString(int dsmccType) {
        return switch (dsmccType) {
            case 1 -> "User-to-Network configuration message";
            case 2 -> "User-to-Network session message";
            case 3 -> "Download message";
            case 4 -> "SDB Channel Change Protocol message";
            case 5 -> "User-to- Network pass-thru message";
            default -> dsmccType >= 128 && dsmccType <= 255 ? "User Defined message type" : "reserved";
        };
    }

    private static String getMessageIDString(int dsmccType, int messageId) {
        return switch (dsmccType) {
            case 3 -> {
                switch (messageId) {
                    case 4097: {
                        yield "DownloadInfoRequest";
                    }
                    case 4098: {
                        yield "DownloadInfoIndication";
                    }
                    case 4099: {
                        yield "DownloadDataBlock";
                    }
                    case 4100: {
                        yield "DownloadDataRequest";
                    }
                    case 4101: {
                        yield "DownloadCancel";
                    }
                    case 4102: {
                        yield "DownloadServerInitiate";
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    public static String getTransactionIDString(long transactionID) {
        StringBuilder s = new StringBuilder();
        s.append("Originator: ").append((transactionID & 0xC0000000L) >> 30);
        s.append(", Version: ").append((transactionID & 0x3FFF0000L) >> 16);
        s.append(", Identification: ").append((transactionID & 0xFFFEL) >> 1);
        s.append(", Updated flag: ").append(transactionID & 1L);
        return s.toString();
    }

    public boolean isObjectCarousel() {
        return this.isObjectCarousel;
    }

    public DSMCCMessageHeader getHeader() {
        return this.header;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public int getPrivateDataLength() {
        return this.privateDataLength;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }

    public IOR getServiceGatewayIOR() {
        return this.serviceGatewayIOR;
    }

    public int getDownloadTaps_count() {
        return this.downloadTaps_count;
    }

    public int getServiceContextList_count() {
        return this.serviceContextList_count;
    }

    public int getUserInfoLength() {
        return this.userInfoLength;
    }

    public long getDownloadId() {
        return this.downloadId;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getAckPeriod() {
        return this.ackPeriod;
    }

    public long gettCDownloadWindow() {
        return this.tCDownloadWindow;
    }

    public long gettCDownloadScenario() {
        return this.tCDownloadScenario;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public List<ModuleInfo> getModules() {
        return this.modules;
    }

    public ModuleInfo getModule(int modId) {
        for (ModuleInfo module : this.modules) {
            if (module.getModuleId() != modId) continue;
            return module;
        }
        return null;
    }

    public class DSMCCMessageHeader
    implements TreeNode {
        private final int protocolDiscriminator;
        private final int dsmccType;
        private final int messageId;
        private final long transactionID;
        private final int reserved;
        private final int adaptationLength;
        private final int messageLength;

        public DSMCCMessageHeader(int protocolDiscriminator, int dsmccType, int messageId, long transactionID, int reserved, int adaptationLength, int messageLength) {
            this.protocolDiscriminator = protocolDiscriminator;
            this.dsmccType = dsmccType;
            this.messageId = messageId;
            this.transactionID = transactionID;
            this.reserved = reserved;
            this.adaptationLength = adaptationLength;
            this.messageLength = messageLength;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("DSM-CC Message Header");
            t.add(new KVP("protocolDiscriminator", this.protocolDiscriminator));
            t.add(new KVP("dsmccType", this.dsmccType, DSMCC_UNMessageSection.getDSMCCTypeString(this.dsmccType)));
            t.add(new KVP("messageId", this.messageId, DSMCC_UNMessageSection.getMessageIDString(this.dsmccType, this.messageId)));
            t.add(new KVP("transactionID", this.transactionID, DSMCC_UNMessageSection.getTransactionIDString(this.transactionID)));
            t.add(new KVP("reserved", this.reserved));
            t.add(new KVP("adaptationLength", this.adaptationLength));
            t.add(new KVP("messageLength", this.messageLength));
            return t;
        }

        public int getProtocolDiscriminator() {
            return this.protocolDiscriminator;
        }

        public int getDsmccType() {
            return this.dsmccType;
        }

        public int getMessageId() {
            return this.messageId;
        }

        public long getDownloadId() {
            return DSMCC_UNMessageSection.this.downloadId;
        }

        public int getReserved() {
            return this.reserved;
        }

        public int getAdaptationLength() {
            return this.adaptationLength;
        }

        public int getMessageLength() {
            return this.messageLength;
        }

        public long getTransactionID() {
            return this.transactionID;
        }
    }

    public static class GroupInfo
    implements TreeNode {
        private final long groupId;
        private final long groupSize;
        private final CompatibilityDescriptor compatibilityDescriptor;

        public GroupInfo(byte[] data, int offset) {
            this.groupId = Utils.getLong(data, offset, 4, -1L);
            this.groupSize = Utils.getLong(data, offset + 4, 4, -1L);
            this.compatibilityDescriptor = new CompatibilityDescriptor(data, offset + 8);
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("GroupInfo");
            t.add(new KVP("groupId", this.groupId));
            t.add(new KVP("groupSize", this.groupSize));
            t.add(this.compatibilityDescriptor.getJTreeNode(modus));
            return t;
        }

        public int len() {
            return this.compatibilityDescriptor.getCompatibilityDescriptorLength() + 10;
        }

        public long getGroupId() {
            return this.groupId;
        }

        public long getGroupSize() {
            return this.groupSize;
        }

        public CompatibilityDescriptor getCompatibilityDescriptor() {
            return this.compatibilityDescriptor;
        }
    }

    public class ModuleInfo
    implements TreeNode {
        private List<Descriptor> descriptors;
        private final int moduleId;
        private final long moduleSize;
        private final int moduleVersion;
        private final int moduleInfoLength;
        private final byte[] moduleInfoByte;
        private BIOPModuleInfo biopModuleInfo;

        public ModuleInfo(int moduleId, long moduleSize, int moduleVersion, int moduleInfoLength, byte[] moduleInfoByte) {
            this.moduleId = moduleId;
            this.moduleSize = moduleSize;
            this.moduleVersion = moduleVersion;
            this.moduleInfoLength = moduleInfoLength;
            this.moduleInfoByte = moduleInfoByte;
            if (moduleInfoLength > 0) {
                if (DSMCC_UNMessageSection.this.isObjectCarousel) {
                    this.biopModuleInfo = new BIOPModuleInfo(moduleInfoByte, 0);
                } else {
                    this.descriptors = DSMCCDescriptorFactory.buildDescriptorList(moduleInfoByte, 0, moduleInfoLength);
                }
            }
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("Module", this.moduleId);
            t.add(new KVP("moduleId", this.moduleId));
            t.add(new KVP("moduleSize", this.moduleSize));
            t.add(new KVP("moduleVersion", this.moduleVersion));
            t.add(new KVP("moduleInfoLength", this.moduleInfoLength));
            t.add(new KVP("moduleInfoByte", this.moduleInfoByte));
            if (this.moduleInfoLength > 0) {
                if (DSMCC_UNMessageSection.this.isObjectCarousel) {
                    t.add(this.biopModuleInfo.getJTreeNode(modus));
                } else {
                    Utils.addListJTree(t, this.descriptors, modus, "descriptors");
                }
            }
            return t;
        }

        public int getModuleId() {
            return this.moduleId;
        }

        public long getModuleSize() {
            return this.moduleSize;
        }

        public int getModuleVersion() {
            return this.moduleVersion;
        }

        public int getModuleInfoLength() {
            return this.moduleInfoLength;
        }

        public byte[] getModuleInfoByte() {
            return this.moduleInfoByte;
        }

        public BIOPModuleInfo getBiopModuleInfo() {
            return this.biopModuleInfo;
        }
    }
}

