/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CarouselIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.CompressedModuleDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPDirectoryMessage;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPFileMessage;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPMessage;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPMessageFactory;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPModuleInfo;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPName;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPObjectLocation;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPStreamEventMessage;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC_UNMessageSection;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMConnBinder;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.IOR;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.LiteComponent;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.TaggedProfile;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.Tap;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.gui.SaveAble;
import nl.digitalekabeltelevisie.util.Utils;

public class ServiceDSMCC
implements TreeNode {
    private static final Logger logger = Logger.getLogger(ServiceDSMCC.class.getName());
    private Map<Integer, DSMCC> dsmccs = new HashMap<Integer, DSMCC>();
    private Map<Integer, ObjectCarousel> bootList = new HashMap<Integer, ObjectCarousel>();
    private final int programNumber;
    private PSI psi;

    public List<BIOPMessage> getBIOPMessagesForModule(DSMCC_UNMessageSection dii, int moduleId) {
        Tap moduleTap;
        int moduleAssociationTag;
        DSMCC ddbPid;
        byte[] rawData;
        List<Tap> moduleTaps;
        BIOPModuleInfo biopModInfo;
        List<BIOPMessage> biopMessages = null;
        DSMCC_UNMessageSection.ModuleInfo moduleInfo = dii.getModule(moduleId);
        if (moduleInfo != null && (biopModInfo = moduleInfo.getBiopModuleInfo()) != null && (moduleTaps = biopModInfo.getTaps()) != null && !moduleTaps.isEmpty() && (rawData = (ddbPid = this.dsmccs.get(moduleAssociationTag = (moduleTap = moduleTaps.getFirst()).getAssociation_tag())).getDDMbytes(moduleInfo)) != null) {
            rawData = this.uncompressModuleData(biopModInfo, rawData);
            biopMessages = BIOPMessageFactory.createBIOPMessages(rawData, 0);
        }
        return biopMessages;
    }

    public byte[] uncompressModuleData(BIOPModuleInfo biopModInfo, byte[] rawData) {
        List<CompressedModuleDescriptor> compressedModuleDescriptorsList;
        byte[] res = rawData;
        List<Descriptor> moduleDescriptors = biopModInfo.getDescriptors();
        if (moduleDescriptors != null && !moduleDescriptors.isEmpty() && (compressedModuleDescriptorsList = Descriptor.findGenericDescriptorsInList(moduleDescriptors, CompressedModuleDescriptor.class)) != null && !compressedModuleDescriptorsList.isEmpty()) {
            CompressedModuleDescriptor compressedModuleDescriptor = compressedModuleDescriptorsList.getFirst();
            int original_size = (int)compressedModuleDescriptor.getOriginal_size();
            res = this.decompress(rawData, original_size);
        }
        return res;
    }

    public byte[] decompress(byte[] rawData, int original_size) {
        byte[] res = rawData;
        Inflater decompressor = new Inflater();
        decompressor.setInput(res);
        byte[] uncompressed = new byte[original_size];
        try {
            int inflated = decompressor.inflate(uncompressed);
            decompressor.end();
            if (inflated == original_size) {
                res = uncompressed;
            } else {
                logger.log(Level.WARNING, "Error inflating data, inflated!=original_size");
            }
        }
        catch (DataFormatException e) {
            logger.log(Level.WARNING, "inflating DSM-CC failed:", e);
        }
        return res;
    }

    public ServiceDSMCC(int programNum) {
        this.programNumber = programNum;
    }

    public void addDSMCC(int association_tag, DSMCC dsmcc) {
        this.dsmccs.put(association_tag, dsmcc);
        this.psi = dsmcc.getParentPSI();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("DSM-CC ObjectCarousel components for program", this.programNumber, this.psi.getSdt().getServiceNameForActualTransportStream(this.programNumber));
        TreeSet<Integer> s = new TreeSet<Integer>(this.dsmccs.keySet());
        for (int associationTag : s) {
            KVP association = new KVP("Association: " + associationTag);
            DSMCC dsmcc = this.dsmccs.get(associationTag);
            association.add(new KVP("PID", dsmcc.getPid()));
            t.add(association);
        }
        t.addList(this.bootList.values(), modus, "ObjectCarousels");
        return t;
    }

    public void addBootPID(int associationTag, int dataBroadCastId) {
        this.bootList.put(associationTag, new ObjectCarousel(associationTag, dataBroadCastId));
    }

    public BIOPMessage getBIOPMessage(CarouselIdentifierDescriptor carouselIdentifierDescriptor, int associationTag) {
        BIOPMessage biopMessage = null;
        DSMCC ddbPid = this.dsmccs.get(associationTag);
        byte[] rawData = ddbPid.getDDMbytes(carouselIdentifierDescriptor.getModuleId());
        if (rawData != null) {
            List<BIOPMessage> biopMessages;
            if (carouselIdentifierDescriptor.getCompressionMethod() != 0) {
                rawData = this.decompress(rawData, (int)carouselIdentifierDescriptor.getOriginalSize());
            }
            if ((biopMessages = BIOPMessageFactory.createBIOPMessages(rawData, 0)) != null) {
                byte[] findObjectKey = carouselIdentifierDescriptor.getObjectKeyData();
                for (BIOPMessage biopMessage2 : biopMessages) {
                    byte[] foundObjectKey = biopMessage2.getObjectKey_data_byte();
                    if (!Utils.equals(findObjectKey, 0, findObjectKey.length, foundObjectKey, 0, foundObjectKey.length)) continue;
                    return biopMessage2;
                }
            }
        }
        return biopMessage;
    }

    public BIOPMessage getBIOPMessage(IOR ior) {
        List<LiteComponent> components;
        TaggedProfile profile;
        BIOPMessage biopMessage = null;
        List<TaggedProfile> profiles = ior.getProfiles();
        if (profiles != null && !profiles.isEmpty() && (profile = ior.getProfiles().getFirst()) != null && (components = profile.getLiteComponents()) != null && components.size() > 1) {
            LiteComponent objectLocation = components.get(0);
            LiteComponent connBinder = components.get(1);
            if (objectLocation instanceof BIOPObjectLocation) {
                long transaction;
                int tableExtension;
                DSMCC_UNMessageSection dii;
                int association;
                DSMCC diiPid;
                Tap tap;
                DSMConnBinder connBind;
                List<Tap> taps;
                BIOPObjectLocation biopObjectLocation = (BIOPObjectLocation)objectLocation;
                if (connBinder instanceof DSMConnBinder && (taps = (connBind = (DSMConnBinder)connBinder).getTaps()) != null && !taps.isEmpty() && (tap = connBind.getTaps().getFirst()) != null && (diiPid = this.dsmccs.get(association = tap.getAssociation_tag())) != null && (dii = diiPid.getDII(tableExtension = (int)((transaction = tap.getTransactionId()) & 0xFFFFL))) != null) {
                    int moduleId = biopObjectLocation.getModuleId();
                    byte[] findObjectKey = biopObjectLocation.getObjectKey_data_byte();
                    List<BIOPMessage> biopMessages = this.getBIOPMessagesForModule(dii, moduleId);
                    if (biopMessages != null) {
                        for (BIOPMessage biopMessage2 : biopMessages) {
                            byte[] foundObjectKey = biopMessage2.getObjectKey_data_byte();
                            if (!Utils.equals(findObjectKey, 0, findObjectKey.length, foundObjectKey, 0, foundObjectKey.length)) continue;
                            return biopMessage2;
                        }
                    }
                }
            }
        }
        return biopMessage;
    }

    public void setCarouselIdentifierDescriptor(int associationTag, CarouselIdentifierDescriptor carouselIdentifierDescriptor) {
        ObjectCarousel objectCarousel = this.bootList.get(associationTag);
        if (objectCarousel != null) {
            objectCarousel.setCarouselIdentifierDescriptor(carouselIdentifierDescriptor);
        }
    }

    public class ObjectCarousel
    implements TreeNode {
        private final int associationTag;
        private final int dataBroadCastId;
        private CarouselIdentifierDescriptor carouselIdentifierDesc;

        public ObjectCarousel(int associationTag, int dataBroadCastId) {
            this.associationTag = associationTag;
            this.dataBroadCastId = dataBroadCastId;
        }

        private void addToTree(BIOPMessage biopMessage, String label, DefaultMutableTreeNode s, int modus) {
            if (biopMessage != null) {
                if (biopMessage instanceof BIOPDirectoryMessage) {
                    BIOPDirectoryMessage dir = (BIOPDirectoryMessage)biopMessage;
                    s.add(dir.getJTreeNode(modus, label));
                    List<BIOPDirectoryMessage.Binding> bindings = dir.getBindingList();
                    for (BIOPDirectoryMessage.Binding binding : bindings) {
                        BIOPName biopName = binding.getBiopName();
                        IOR ior = binding.getIor();
                        BIOPMessage child = ServiceDSMCC.this.getBIOPMessage(ior);
                        if (child == null || biopName == null) continue;
                        this.addToTree(child, label + "/" + biopName.getName(), s, modus);
                    }
                } else {
                    s.add(biopMessage.getJTreeNode(modus, label));
                }
            }
        }

        private KVP buildTree(BIOPMessage biopMessage, String label, int modus) {
            KVP treeNode = new KVP(label);
            if (biopMessage instanceof BIOPDirectoryMessage) {
                BIOPDirectoryMessage dir = (BIOPDirectoryMessage)biopMessage;
                DSMFile dsmFile = new DSMFile(dir, label);
                treeNode.addHTMLSource(dsmFile, "directory_message");
                JMenuItem objectMenu = new JMenuItem("Export (sub)tree...");
                objectMenu.setActionCommand("export");
                treeNode.setSubMenuAndOwner(objectMenu, dsmFile);
                List<BIOPDirectoryMessage.Binding> bindings = dir.getBindingList();
                for (BIOPDirectoryMessage.Binding binding : bindings) {
                    BIOPName biopName = binding.getBiopName();
                    IOR ior = binding.getIor();
                    BIOPMessage child = ServiceDSMCC.this.getBIOPMessage(ior);
                    if (child == null || biopName == null) continue;
                    treeNode.add(this.buildTree(child, biopName.getName(), modus));
                }
            } else if (biopMessage instanceof BIOPFileMessage) {
                JMenuItem objectMenu = new JMenuItem("Save as...");
                objectMenu.setActionCommand("save");
                DSMFile dsmFile = new DSMFile(biopMessage, label);
                treeNode.addHTMLSource(dsmFile, "file_message");
                treeNode.setSubMenuAndOwner(objectMenu, dsmFile);
            } else if (biopMessage instanceof BIOPStreamEventMessage) {
                DSMFile dsmFile = new DSMFile(biopMessage, label);
                treeNode.addHTMLSource(dsmFile, "stream_event_message");
            }
            return treeNode;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("Object Carousel");
            s.add(new KVP("associationTag", this.associationTag));
            s.add(new KVP("dataBroadCastId", this.dataBroadCastId, Utils.getDataBroadCastIDString(this.dataBroadCastId)));
            if (this.carouselIdentifierDesc != null) {
                s.add(this.carouselIdentifierDesc.getJTreeNode(modus));
            }
            DSMCC_UNMessageSection dsi = ServiceDSMCC.this.dsmccs.get(this.associationTag).getDSI();
            if (this.carouselIdentifierDesc != null && this.carouselIdentifierDesc.getFormatId() == 1) {
                BIOPMessage biopMessage = ServiceDSMCC.this.getBIOPMessage(this.carouselIdentifierDesc, this.associationTag);
                this.addTreeDetails(modus, s, biopMessage);
            } else if (dsi != null) {
                IOR ior = dsi.getServiceGatewayIOR();
                BIOPMessage biopMessage = ServiceDSMCC.this.getBIOPMessage(ior);
                this.addTreeDetails(modus, s, biopMessage);
            }
            return s;
        }

        public void addTreeDetails(int modus, KVP s, BIOPMessage biopMessage) {
            KVP messages = new KVP("Messages");
            this.addToTree(biopMessage, "", messages, modus);
            s.add(messages);
            if (biopMessage != null) {
                s.add(this.buildTree(biopMessage, "ObjectHierarchy", modus));
            }
        }

        public void setCarouselIdentifierDescriptor(CarouselIdentifierDescriptor carouselIdentifierDescriptor) {
            this.carouselIdentifierDesc = carouselIdentifierDescriptor;
        }
    }

    public class DSMFile
    implements HTMLSource,
    SaveAble {
        private BIOPMessage biopMessage;
        private String label;

        public DSMFile(BIOPMessage biopMessage, String label) {
            this.biopMessage = biopMessage;
            this.label = label;
        }

        public BIOPMessage getBiopMessage() {
            return this.biopMessage;
        }

        public void setBiopMessage(BIOPFileMessage biopMessage) {
            this.biopMessage = biopMessage;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getHTML() {
            StringBuilder b = new StringBuilder();
            BIOPMessage bIOPMessage = this.biopMessage;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BIOPFileMessage.class, BIOPDirectoryMessage.class, BIOPStreamEventMessage.class}, (Object)bIOPMessage, n)) {
                case 0: {
                    BIOPFileMessage fileMes = (BIOPFileMessage)bIOPMessage;
                    b.append("Type: File<br>Size:");
                    b.append(fileMes.getContent_length());
                    b.append("<br>Data:<br>");
                    b.append(Utils.getHTMLHexview(fileMes.getData(), fileMes.getContentStartOffset(), (int)fileMes.getContent_length()));
                    break;
                }
                case 1: {
                    BIOPDirectoryMessage dirMes = (BIOPDirectoryMessage)bIOPMessage;
                    b.append("Type: Directory<br>Descendants:<br>");
                    for (BIOPDirectoryMessage.Binding binding : dirMes.getBindingList()) {
                        b.append(binding.getBiopName().getName()).append(": (").append(BIOPDirectoryMessage.getBindingTypeString(binding.getBindingType())).append(")<br>");
                    }
                    break;
                }
                case 2: {
                    BIOPStreamEventMessage eventMsg = (BIOPStreamEventMessage)bIOPMessage;
                    b.append("Type: StreamEvent<br>EventNames:<br>");
                    for (BIOPStreamEventMessage.EventName eventName : eventMsg.getEventNames()) {
                        b.append(new String(eventName.eventName_data_byte())).append("<br>");
                    }
                    break;
                }
            }
            return b.toString();
        }

        @Override
        public void save(File file) {
            this.saveFile(file, this.biopMessage);
        }

        public void saveFile(File file, BIOPMessage biopMessage) {
            logger.info("saveFile called for file path:" + file.getAbsolutePath() + ", name:" + file.getName());
            if (biopMessage instanceof BIOPFileMessage) {
                BIOPFileMessage biopFile = (BIOPFileMessage)biopMessage;
                logger.info("starting write file");
                try (FileOutputStream out = new FileOutputStream(file);){
                    out.write(biopFile.getData(), biopFile.getContentStartOffset(), (int)biopFile.getContent_length());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "could not write file", e);
                }
            } else if (biopMessage instanceof BIOPDirectoryMessage) {
                BIOPDirectoryMessage dirMes = (BIOPDirectoryMessage)biopMessage;
                logger.log(Level.INFO, "trying to create directory " + String.valueOf(file));
                boolean success = file.mkdir();
                logger.log(Level.INFO, "trying to create directory. result " + success);
                for (BIOPDirectoryMessage.Binding binding : dirMes.getBindingList()) {
                    String descName = binding.getBiopName().getName();
                    IOR ior = binding.getIor();
                    BIOPMessage child = ServiceDSMCC.this.getBIOPMessage(ior);
                    if (child == null || descName == null) continue;
                    logger.log(Level.INFO, "now going down to save:" + descName);
                    this.saveFile(new File(file, descName), child);
                }
            }
        }
    }
}

