/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.LiteComponent;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.LiteComponentsFactory;
import nl.digitalekabeltelevisie.util.Utils;

public class TaggedProfile
implements TreeNode {
    private long profileId_tag = 0L;
    private final long profile_data_length;
    public static final long TAG_BIOP = 1230196486L;
    public static final long TAG_LITE_OPTIONS = 1230196485L;
    private final int profile_data_byte_order;
    private final int liteComponents_count;
    private final List<LiteComponent> liteComponents = new ArrayList<LiteComponent>();
    public byte[] profile_data = null;

    public TaggedProfile(byte[] data, int offset) {
        this.profileId_tag = Utils.getLong(data, offset, 4, -1L);
        this.profile_data_length = Utils.getLong(data, offset + 4, 4, -1L);
        this.profile_data = Arrays.copyOfRange(data, offset + 8, offset + 8 + (int)this.profile_data_length);
        this.profile_data_byte_order = Utils.getInt(data, offset + 8, 1, 255);
        this.liteComponents_count = Utils.getInt(data, offset + 9, 1, 255);
        int liteOffset = offset + 10;
        for (int i = 0; i < this.liteComponents_count; ++i) {
            LiteComponent liteComponent = LiteComponentsFactory.createLiteComponent(data, liteOffset);
            this.liteComponents.add(liteComponent);
            liteOffset += 5 + liteComponent.getComponentDataLength();
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("TaggedProfile");
        t.add(new KVP("profileId_tag", this.profileId_tag, TaggedProfile.getProfileIdTagString(this.profileId_tag)));
        t.add(new KVP("profile_data_length", this.profile_data_length));
        t.add(new KVP("profile_data", this.profile_data));
        t.add(new KVP("profile_data_byte_order", this.profile_data_byte_order));
        t.add(new KVP("liteComponents_count", this.liteComponents_count));
        Utils.addListJTree(t, this.liteComponents, modus, "LiteComponents");
        return t;
    }

    public static String getProfileIdTagString(long profileId_tag) {
        if (profileId_tag == 1230196486L) {
            return "TAG_BIOP (BIOP Profile Body)";
        }
        if (profileId_tag == 1230196485L) {
            return "TAG_LITE_OPTIONS (Lite Options Profile Body)";
        }
        return null;
    }

    public long getProfile_data_length() {
        return this.profile_data_length;
    }

    public byte[] getProfile_data() {
        return this.profile_data;
    }

    public long getProfileId_tag() {
        return this.profileId_tag;
    }

    public int getProfile_data_byte_order() {
        return this.profile_data_byte_order;
    }

    public int getLiteComponents_count() {
        return this.liteComponents_count;
    }

    public List<LiteComponent> getLiteComponents() {
        return this.liteComponents;
    }
}

