/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DVBSubtitlingPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.Video138182Handler;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.util.Utils;

public class GeneralPesHandler
extends GeneralPidHandler {
    private static final Logger logger = Logger.getLogger(GeneralPesHandler.class.getName());
    private PesPacketData pesData = null;
    protected final List<PesPacketData> pesPackets = new ArrayList<PesPacketData>();
    protected static final int DEFAULT_BUF_LEN = 10;
    protected byte[] pesDataBuffer = new byte[10];
    protected int bufStart = 0;
    protected int bufEnd = 0;

    protected void processPesDataBytes(PesPacketData pesData) {
        this.pesPackets.add(pesData);
    }

    @Override
    public void processTSPacket(TSPacket packet) {
        this.initialized = true;
        byte[] data = packet.getData();
        int pesLength = -1;
        int pesStreamID = -1;
        if (this.pesData == null) {
            if (packet.isPayloadUnitStartIndicator() && (packet.getAdaptationFieldControl() == 1 || packet.getAdaptationFieldControl() == 3)) {
                if (data[0] != 0 || data[1] != 0) {
                    throw new IllegalStateException("Found PSI data in PESHandler, PID type changed over time (not illegal, however not supported...)");
                }
                if (data[0] == 0 && data[1] == 0 && data[2] == 1) {
                    pesStreamID = Utils.getInt(data, 3, 1, 255);
                    pesLength = Utils.getInt(data, 4, 2, 65535);
                    this.pesData = new PesPacketData(pesStreamID, pesLength, this, packet.getPacketNo());
                    this.pesData.readBytes(data, 0, data.length);
                    this.handlePesPacketIfComplete();
                }
            }
        } else if (packet.getAdaptationFieldControl() == 1 || packet.getAdaptationFieldControl() == 3) {
            if (packet.isPayloadUnitStartIndicator()) {
                if (this.pesData != null) {
                    this.processPesDataBytes(this.pesData);
                }
                if (data.length >= 6) {
                    pesStreamID = Utils.getInt(data, 3, 1, 255);
                    pesLength = Utils.getInt(data, 4, 2, 65535);
                    this.pesData = new PesPacketData(pesStreamID, pesLength, this, packet.getPacketNo());
                    this.pesData.readBytes(data, 0, data.length);
                    this.handlePesPacketIfComplete();
                } else {
                    logger.warning("Not supported: Found PES packet start with data.length<6 at TSPacket: " + packet.getPacketNo());
                }
            } else if (this.pesData != null) {
                this.pesData.readBytes(data, 0, data.length);
                this.handlePesPacketIfComplete();
            }
        }
    }

    private void handlePesPacketIfComplete() {
        if (this.pesData.isComplete()) {
            this.pesData.processPayload();
            this.processPesDataBytes(this.pesData);
            this.pesData = null;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("PES Data"));
        Utils.addListJTree(s, this.pesPackets, modus, "PES Packets");
        return s;
    }

    public List<PesPacketData> getPesPackets() {
        return this.pesPackets;
    }

    public BufferedImage getBGImage(int height, int width, long pts) {
        GeneralPidHandler pesHandler;
        PID pid;
        int videoPID;
        BufferedImage bgImage = null;
        PMTsection pmt = this.getTransportStream().getPMTforPID(this.getPID().getPid());
        if (pmt != null && (videoPID = Utils.findMPEG2VideoPid(pmt)) > 0 && (pid = this.getTransportStream().getPids()[videoPID]) != null && (pesHandler = pid.getPidHandler()) != null && pesHandler.isInitialized() && pesHandler instanceof Video138182Handler) {
            Video138182Handler videoHandler = (Video138182Handler)pesHandler;
            bgImage = videoHandler.getImage(height, width, pts);
        }
        if (bgImage == null) {
            bgImage = DVBSubtitlingPESDataField.bgImage576;
            if (height == 1080) {
                bgImage = DVBSubtitlingPESDataField.bgImage1080;
            } else if (height == 720) {
                bgImage = DVBSubtitlingPESDataField.bgImage720;
            }
        }
        return bgImage;
    }

    protected void copyIntoBuf(PesPacketData pesDataField) {
        int len = pesDataField.getPesDataLen();
        if (len + this.bufEnd > this.pesDataBuffer.length) {
            byte[] newBuf = new byte[Math.max(len + this.bufEnd - this.bufStart, 10)];
            System.arraycopy(this.pesDataBuffer, this.bufStart, newBuf, 0, this.bufEnd - this.bufStart);
            this.pesDataBuffer = newBuf;
            this.bufEnd -= this.bufStart;
            this.bufStart = 0;
        }
        System.arraycopy(pesDataField.getData(), pesDataField.getPesDataStart(), this.pesDataBuffer, this.bufEnd, pesDataField.getPesDataLen());
        this.bufEnd += pesDataField.getPesDataLen();
    }
}

