/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ac3;

import nl.digitalekabeltelevisie.util.BitSource;

public class AbstractAC3SyncFrame {
    private static int[] ac3_bitrate_index = new int[]{32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static int[][] ac3_size_table = new int[][]{{64, 64, 80, 80, 96, 96, 112, 112, 128, 128, 160, 160, 192, 192, 224, 224, 256, 256, 320, 320, 384, 384, 448, 448, 512, 512, 640, 640, 768, 768, 896, 896, 1024, 1024, 1152, 1152, 1280, 1280}, {69, 70, 87, 88, 104, 105, 121, 122, 139, 140, 174, 175, 208, 209, 243, 244, 278, 279, 348, 349, 417, 418, 487, 488, 557, 558, 696, 697, 836, 835, 975, 976, 1114, 1115, 1253, 1254, 1393, 1394}, {96, 96, 120, 120, 144, 144, 168, 168, 192, 192, 240, 240, 288, 288, 336, 336, 384, 384, 480, 480, 576, 576, 672, 672, 768, 768, 960, 960, 1152, 1152, 1344, 1344, 1560, 1560, 1728, 1728, 1920, 1920}};
    protected int syncword;
    protected int fscod;
    protected int bsid;
    protected int lfeon;
    protected int dialnorm;
    protected int compre;
    protected int compr;
    protected int audprodie;
    protected int mixlevel;
    protected int roomtyp;
    protected int dialnorm2;
    protected int compr2e;
    protected int audprodi2e;
    protected int mixlevel2;
    protected int roomtyp2;
    protected BitSource bs = null;
    protected int offset;
    protected int dmixmod;
    protected int compr2;
    protected int ltrtcmixlev;
    protected int ltrtsurmixlev;
    protected int lorocmixlev;
    protected int lorosurmixlev;
    protected int bsmod;
    protected int dsurmod;
    protected int copyrightb;
    protected int origbs;
    protected int dheadphonmod;
    protected int addbsil;
    protected int frmsizecod;
    protected int addbsie;
    protected int crc1;
    protected int acmod;
    protected int cmixlev;
    protected int surmixlev;
    protected int langcode;
    protected int langcod;
    protected int langcod2e;
    protected int langcod2;
    protected int timecod1e;
    protected int timecod1;
    protected int timecod2e;
    protected int timecod2;
    protected int dsurexmod;
    protected int adconvtyp;

    public AbstractAC3SyncFrame(byte[] data, int offset) {
        this.offset = offset;
        this.bs = new BitSource(data, offset);
    }

    public static String getBsidString(int bsid) {
        String t = "";
        t = bsid == 16 ? "E-AC-3" : (bsid == 6 ? "AC3 Alternate bit stream syntax" : (bsid == 8 ? "AC3 normal syntax" : (bsid < 8 ? "AC3 backward compatible" : (bsid == 9 || bsid == 10 ? "AC3 newer version" : (bsid > 10 && bsid < 16 ? "E-AC-3 backward compatible" : "E-AC-3 newer version")))));
        return "Bit stream identification " + t;
    }

    protected static String getLfeOnString(int lfeon) {
        return lfeon == 1 ? "Low frequency effects channel is on" : "Low frequency effects channel is off";
    }

    protected static String getDialNormString(int dialnorm) {
        return "Dialogue normalization: " + (String)(dialnorm == 0 ? "Reserved" : "-" + dialnorm + " dB");
    }

    protected static String getCompreString(int compre) {
        return compre == 1 ? "Compression gain word exists" : "No compression gain word exists";
    }

    public static String getSampleRateCodeString(int fscod) {
        switch (fscod) {
            case 0: {
                return "48 kHz";
            }
            case 1: {
                return "44,1 kHz";
            }
            case 2: {
                return "32 kHz";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "illegal value";
    }

    public static String getDmixmodString(int dmixmod2) {
        switch (dmixmod2) {
            case 0: {
                return "Not indicated";
            }
            case 1: {
                return "Lt/Rt downmix preferred";
            }
            case 2: {
                return "Lo/Ro downmix preferred";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "Illegal value";
    }

    public static String getDheadphonmodString(int dheadphonmod) {
        String[] desc = new String[]{"Not indicated", "Not Dolby Headphone encoded", "Dolby Headphone encoded", "Reserved"};
        return desc[dheadphonmod];
    }

    public static String getDsurmodString(int dsurmod) {
        String[] desc = new String[]{"Not indicated", "NOT Dolby surround encoded", "Dolby surround encoded", "Reserved"};
        return desc[dsurmod];
    }

    public static String getDsurexmodString(int dsurexmod) {
        String[] desc = new String[]{"Not indicated", "Not Dolby Surround EX encoded", "Dolby Surround EX encoded", "Reserved"};
        return desc[dsurexmod];
    }

    public static String getRoomTypeString(int roomtyp) {
        switch (roomtyp) {
            case 0: {
                return "Not indicated";
            }
            case 1: {
                return "Large room, X curve monitor";
            }
            case 2: {
                return "Small room, flat monitor";
            }
            case 3: {
                return "reserved";
            }
        }
        return "Illegal value";
    }

    public static String getFrmsizecodString(int fscod, int frmsizecod) {
        if (fscod >= 0 && fscod < 3 && frmsizecod >= 0 && frmsizecod <= 37) {
            return "Nominal bit rate: " + ac3_bitrate_index[frmsizecod >>> 1] + ", words/syncframe: " + ac3_size_table[fscod][frmsizecod];
        }
        return "illegal values for fscod: " + fscod + " or frmsizecod: " + frmsizecod;
    }

    public static String getBsModString(int bsmod, int acmod) {
        switch (bsmod) {
            case 0: {
                return "Main audio service: complete main (CM)";
            }
            case 1: {
                return "Main audio service: music and effects (ME)";
            }
            case 2: {
                return "Associated service: visually impaired (VI)";
            }
            case 3: {
                return "Associated service: hearing impaired (HI)";
            }
            case 4: {
                return "Associated service: dialogue (D)";
            }
            case 5: {
                return "Associated service: commentary (C)";
            }
            case 6: {
                return "Associated service: emergency (E)";
            }
            case 7: {
                if (acmod == 1) {
                    return "Associated service: dialogue (D)";
                }
                if (acmod >= 2 && acmod <= 7) {
                    return "Main audio service: karaoke";
                }
                return "Illegal value for acmod: " + acmod;
            }
        }
        return "Illegal Value for bsmod: " + bsmod;
    }

    public static String getCentreMixLevelString(int cmixlev) {
        switch (cmixlev) {
            case 0: {
                return "0,707 (-3,0 dB)";
            }
            case 1: {
                return "0,595 (-4,5 dB)";
            }
            case 2: {
                return "0,500 (-6,0 dB)";
            }
            case 3: {
                return "reserved";
            }
        }
        return "Illegal value";
    }

    public static String getSurroundMixLevelString(int surmixlev) {
        switch (surmixlev) {
            case 0: {
                return "0,707 (-3,0 dB)";
            }
            case 1: {
                return "0,500 (-6 dB)";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "reserved";
            }
        }
        return "Illegal value";
    }

    public static String getACModString(int acmod) {
        switch (acmod) {
            case 0: {
                return "1 + 1";
            }
            case 1: {
                return "1/0";
            }
            case 2: {
                return "2/0";
            }
            case 3: {
                return "3/0";
            }
            case 4: {
                return "2/1";
            }
            case 5: {
                return "3/1";
            }
            case 6: {
                return "2/2";
            }
            case 7: {
                return "3/2";
            }
        }
        return "Illegal Value for acmod: " + acmod;
    }

    public static String getCmixlevString(int cmixlev) {
        String[] desc = new String[]{"1,414 (+3,0 dB)", "1,189 (+1,5 dB)", "1,000 (0,0 dB)", "0,841 (-1,5 dB)", "0,707 (-3,0 dB)", "0,595 (-4,5 dB)", "0,500 (-6,0 dB)", "0,000 (-inf dB)"};
        return desc[cmixlev];
    }

    public static String getSurmixlevString(int surmixlev) {
        String[] desc = new String[]{"Reserved", "Reserved", "Reserved", "0,841 (-1,5 dB)", "0,707 (-3,0 dB)", "0,595 (-4,5 dB)", "0,500 (-6,0 dB)", "0,000 (-inf dB)"};
        return desc[surmixlev];
    }

    public static int[] getAc3_bitrate_index() {
        return ac3_bitrate_index;
    }

    public static int[][] getAc3_size_table() {
        return ac3_size_table;
    }

    public static String doesExistString(int p) {
        if (p == 1) {
            return "does exist";
        }
        return "does not exist";
    }

    public int getSyncword() {
        return this.syncword;
    }

    public int getFscod() {
        return this.fscod;
    }

    public int getBsid() {
        return this.bsid;
    }

    public int getLfeon() {
        return this.lfeon;
    }

    public int getDialnorm() {
        return this.dialnorm;
    }

    public int getCompre() {
        return this.compre;
    }

    public int getCompr() {
        return this.compr;
    }

    public int getAudprodie() {
        return this.audprodie;
    }

    public int getMixlevel() {
        return this.mixlevel;
    }

    public int getRoomtyp() {
        return this.roomtyp;
    }

    public int getDialnorm2() {
        return this.dialnorm2;
    }

    public int getCompr2e() {
        return this.compr2e;
    }

    public int getAudprodi2e() {
        return this.audprodi2e;
    }

    public int getMixlevel2() {
        return this.mixlevel2;
    }

    public int getRoomtyp2() {
        return this.roomtyp2;
    }

    public BitSource getBs() {
        return this.bs;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDmixmod() {
        return this.dmixmod;
    }

    public int getCompr2() {
        return this.compr2;
    }

    public int getLtrtcmixlev() {
        return this.ltrtcmixlev;
    }

    public int getLtrtsurmixlev() {
        return this.ltrtsurmixlev;
    }

    public int getLorocmixlev() {
        return this.lorocmixlev;
    }

    public int getLorosurmixlev() {
        return this.lorosurmixlev;
    }

    public int getBsmod() {
        return this.bsmod;
    }

    public int getDsurmod() {
        return this.dsurmod;
    }

    public int getCopyrightb() {
        return this.copyrightb;
    }

    public int getOrigbs() {
        return this.origbs;
    }

    public int getDheadphonmod() {
        return this.dheadphonmod;
    }

    public int getAddbsil() {
        return this.addbsil;
    }

    public int getFrmsizecod() {
        return this.frmsizecod;
    }

    public int getAddbsie() {
        return this.addbsie;
    }

    public int getCrc1() {
        return this.crc1;
    }

    public int getAcmod() {
        return this.acmod;
    }

    public int getCmixlev() {
        return this.cmixlev;
    }

    public int getSurmixlev() {
        return this.surmixlev;
    }

    public int getLangcode() {
        return this.langcode;
    }

    public int getLangcod() {
        return this.langcod;
    }

    public int getLangcod2e() {
        return this.langcod2e;
    }

    public int getLangcod2() {
        return this.langcod2;
    }

    public int getTimecod1e() {
        return this.timecod1e;
    }

    public int getTimecod1() {
        return this.timecod1;
    }

    public int getTimecod2e() {
        return this.timecod2e;
    }

    public int getTimecod2() {
        return this.timecod2;
    }

    public int getDsurexmod() {
        return this.dsurexmod;
    }

    public int getAdconvtyp() {
        return this.adconvtyp;
    }
}

