/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ac3;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AbstractAC3SyncFrame;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;

public class EAC3SyncFrame
extends AbstractAC3SyncFrame
implements TreeNode {
    private int strmtyp;
    private int lfemixlevcode;
    private int lfemixlevcod;
    private int substreamid;
    private int frmsiz;
    private int fscod2;
    private int numblkscod;
    private int chanmape;
    private int chanmap;
    private int mixmdate;
    private int pgmscle;
    private int pgmscl;
    private int pgmscl2e;
    private int pgmscl2;
    private int extpgmscle;
    private int extpgmscl;
    private int mixdef;
    private int premixcmpsel;
    private int drcsrc;
    private int premixcmpscl;
    private int mixdata;
    private int mixdeflen;
    private int paninfoe;
    private int panmean;
    private int paninfo;
    private int paninfo2e;
    private int panmean2;
    private int paninfo2;
    private int frmmixcfginfoe;
    private int[] blkmixcfginfo;
    private int[] blkmixcfginfoe;
    private int infomdate;
    private int adconvtyp2;
    private int sourcefscod;
    private int blkid;
    private int convsync;

    public EAC3SyncFrame(byte[] data, int offset) {
        super(data, offset);
        this.syncword = this.bs.readBits(16);
        this.strmtyp = this.bs.readBits(2);
        this.substreamid = this.bs.readBits(3);
        this.frmsiz = this.bs.readBits(11);
        this.fscod = this.bs.readBits(2);
        if (this.fscod == 3) {
            this.fscod2 = this.bs.readBits(2);
            this.numblkscod = 3;
        } else {
            this.numblkscod = this.bs.readBits(2);
        }
        this.acmod = this.bs.readBits(3);
        this.lfeon = this.bs.readBits(1);
        this.bsid = this.bs.readBits(5);
        this.dialnorm = this.bs.readBits(5);
        this.compre = this.bs.readBits(1);
        if (this.compre == 1) {
            this.compr = this.bs.readBits(8);
        }
        if (this.acmod == 0) {
            this.dialnorm2 = this.bs.readBits(5);
            this.compr2e = this.bs.readBits(1);
            if (this.compr2e == 1) {
                this.compr2 = this.bs.readBits(8);
            }
        }
        if (this.strmtyp == 1) {
            this.chanmape = this.bs.readBits(1);
            if (this.chanmape == 1) {
                this.chanmap = this.bs.readBits(16);
            }
        }
        this.mixmdate = this.bs.readBits(1);
        if (this.mixmdate == 1) {
            if (this.acmod > 2) {
                this.dmixmod = this.bs.readBits(2);
            }
            if ((this.acmod & 1) != 0 && this.acmod > 2) {
                this.ltrtcmixlev = this.bs.readBits(3);
                this.lorocmixlev = this.bs.readBits(3);
            }
            if ((this.acmod & 4) != 0) {
                this.ltrtsurmixlev = this.bs.readBits(3);
                this.lorosurmixlev = this.bs.readBits(3);
            }
            if (this.lfeon != 0) {
                this.lfemixlevcode = this.bs.readBits(1);
                if (this.lfemixlevcode != 0) {
                    this.lfemixlevcod = this.bs.readBits(5);
                }
            }
            if (this.strmtyp == 0) {
                this.pgmscle = this.bs.readBits(1);
                if (this.pgmscle != 0) {
                    this.pgmscl = this.bs.readBits(6);
                }
                if (this.acmod == 0) {
                    this.pgmscl2e = this.bs.readBits(1);
                    if (this.pgmscl2e != 0) {
                        this.pgmscl2 = this.bs.readBits(6);
                    }
                }
                this.extpgmscle = this.bs.readBits(1);
                if (this.extpgmscle != 0) {
                    this.extpgmscl = this.bs.readBits(6);
                }
                this.mixdef = this.bs.readBits(2);
                if (this.mixdef == 1) {
                    this.premixcmpsel = this.bs.readBits(1);
                    this.drcsrc = this.bs.readBits(1);
                    this.premixcmpscl = this.bs.readBits(3);
                } else if (this.mixdef == 2) {
                    this.mixdata = this.bs.readBits(12);
                } else if (this.mixdef == 3) {
                    this.mixdeflen = this.bs.readBits(5);
                    for (int i = 0; i < this.mixdeflen + 2; ++i) {
                        this.bs.readBits(8);
                    }
                }
                if (this.acmod < 2) {
                    this.paninfoe = this.bs.readBits(1);
                    if (this.paninfoe != 0) {
                        this.panmean = this.bs.readBits(8);
                        this.paninfo = this.bs.readBits(6);
                    }
                    if (this.acmod == 0) {
                        this.paninfo2e = this.bs.readBits(1);
                        if (this.paninfo2e != 0) {
                            this.panmean2 = this.bs.readBits(8);
                            this.paninfo2 = this.bs.readBits(6);
                        }
                    }
                }
                this.frmmixcfginfoe = this.bs.readBits(1);
                if (this.frmmixcfginfoe != 0) {
                    if (this.numblkscod == 0) {
                        this.blkmixcfginfo = new int[1];
                        this.blkmixcfginfo[0] = this.bs.readBits(5);
                    } else {
                        int number_of_blocks_per_sync_frame = EAC3SyncFrame.getNumBlocks(this.numblkscod);
                        this.blkmixcfginfo = new int[number_of_blocks_per_sync_frame];
                        this.blkmixcfginfoe = new int[number_of_blocks_per_sync_frame];
                        for (int blk = 0; blk < number_of_blocks_per_sync_frame; ++blk) {
                            this.blkmixcfginfoe[blk] = this.bs.readBits(1);
                            if (this.blkmixcfginfoe[blk] == 0) continue;
                            this.blkmixcfginfo[blk] = this.bs.readBits(5);
                        }
                    }
                }
            }
            this.infomdate = this.bs.readBits(1);
            if (this.infomdate != 0) {
                this.bsmod = this.bs.readBits(3);
                this.copyrightb = this.bs.readBits(1);
                this.origbs = this.bs.readBits(1);
                if (this.acmod == 2) {
                    this.dsurmod = this.bs.readBits(2);
                    this.dheadphonmod = this.bs.readBits(2);
                }
                if (this.acmod >= 6) {
                    this.dsurexmod = this.bs.readBits(2);
                }
                this.audprodie = this.bs.readBits(1);
                if (this.audprodie != 0) {
                    this.mixlevel = this.bs.readBits(5);
                    this.roomtyp = this.bs.readBits(2);
                    this.adconvtyp = this.bs.readBits(1);
                }
                if (this.acmod == 0) {
                    this.audprodi2e = this.bs.readBits(1);
                    if (this.audprodi2e != 0) {
                        this.mixlevel2 = this.bs.readBits(5);
                        this.roomtyp2 = this.bs.readBits(2);
                        this.adconvtyp2 = this.bs.readBits(1);
                    }
                }
                if (this.fscod < 3) {
                    this.sourcefscod = this.bs.readBits(1);
                }
            }
            if (this.strmtyp == 0 && this.numblkscod != 3) {
                this.convsync = this.bs.readBits(1);
            }
            if (this.strmtyp == 2) {
                this.blkid = this.numblkscod == 3 ? 1 : this.bs.readBits(1);
                if (this.blkid != 0) {
                    this.frmsizecod = this.bs.readBits(6);
                }
            }
            this.addbsie = this.bs.readBits(1);
            if (this.addbsie != 0) {
                this.addbsil = this.bs.readBits(6);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("EAC3 SyncFrame"));
        s.add(new DefaultMutableTreeNode(new KVP("syncword", this.syncword, "must be 0x0B77")));
        s.add(new DefaultMutableTreeNode(new KVP("strmtyp", this.strmtyp, "Stream type: " + EAC3SyncFrame.getStreamTypeString(this.strmtyp))));
        s.add(new DefaultMutableTreeNode(new KVP("substreamid", this.substreamid, "Substream identification")));
        s.add(new DefaultMutableTreeNode(new KVP("frmsiz", this.frmsiz, "Frame size in 16 bit words: " + (this.frmsiz + 1))));
        s.add(new DefaultMutableTreeNode(new KVP("fscod", this.fscod, "Sample rate code: " + EAC3SyncFrame.getSampleRateCodeString(this.fscod))));
        if (this.fscod == 3) {
            s.add(new DefaultMutableTreeNode(new KVP("fscod2", this.fscod2, "Reduced sampling rate: " + EAC3SyncFrame.getReducedSampleRateCodeString(this.fscod2))));
        } else {
            s.add(new DefaultMutableTreeNode(new KVP("numblkscod", this.numblkscod, EAC3SyncFrame.getNumblkscodString(this.numblkscod))));
        }
        s.add(new DefaultMutableTreeNode(new KVP("acmod", this.acmod, "Audio coding mode: " + EAC3SyncFrame.getACModString(this.acmod))));
        s.add(new DefaultMutableTreeNode(new KVP("lfeon", this.lfeon, EAC3SyncFrame.getLfeOnString(this.lfeon))));
        s.add(new DefaultMutableTreeNode(new KVP("bsid", this.bsid, EAC3SyncFrame.getBsidString(this.bsid))));
        s.add(new DefaultMutableTreeNode(new KVP("dialnorm", this.dialnorm, EAC3SyncFrame.getDialNormString(this.dialnorm))));
        s.add(new DefaultMutableTreeNode(new KVP("compre", this.compre, EAC3SyncFrame.getCompreString(this.compre))));
        if (this.compre == 1) {
            s.add(new DefaultMutableTreeNode(new KVP("compr", this.compr, "Compression gain word")));
        }
        if (this.acmod == 0) {
            s.add(new DefaultMutableTreeNode(new KVP("dialnorm2", this.dialnorm2, "Dialogue normalization: " + (String)(this.dialnorm == 0 ? "Reserved" : "-" + this.dialnorm + " dB"))));
            s.add(new DefaultMutableTreeNode(new KVP("compre2", this.compr2e, this.compr2e == 1 ? "Compression gain word exists" : "No compression gain word exists")));
            if (this.compr2e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("compr2", this.compr2, "Compression gain word")));
            }
        }
        if (this.strmtyp == 1) {
            s.add(new DefaultMutableTreeNode(new KVP("chanmape", this.chanmape, "Custom channel map " + EAC3SyncFrame.doesExistString(this.chanmape) + " (Only dependent substreams can have a custom channel map)")));
            if (this.chanmape == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("chanmap", this.chanmap, null)));
                s.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("chanmap")));
            }
        }
        s.add(new DefaultMutableTreeNode(new KVP("mixmdate", this.mixmdate, this.mixmdate == 1 ? "mixing metadata exists" : "mixing metadata does not exist")));
        if (this.mixmdate == 1) {
            if (this.acmod > 2) {
                s.add(new DefaultMutableTreeNode(new KVP("dmixmod", this.dmixmod, "Preferred stereo downmix mode: " + EAC3SyncFrame.getDmixmodString(this.dmixmod))));
            }
            if ((this.acmod & 1) != 0 && this.acmod > 2) {
                s.add(new DefaultMutableTreeNode(new KVP("ltrtcmixlev", this.ltrtcmixlev, "Lt/Rt center mix level: " + EAC3SyncFrame.getCmixlevString(this.ltrtcmixlev))));
                s.add(new DefaultMutableTreeNode(new KVP("lorocmixlev", this.lorocmixlev, "Lo/Ro center mix level: " + EAC3SyncFrame.getCmixlevString(this.lorocmixlev))));
            }
            if ((this.acmod & 4) != 0) {
                s.add(new DefaultMutableTreeNode(new KVP("ltrtsurmixlev", this.ltrtsurmixlev, "Lt/Rt surround mix level: " + EAC3SyncFrame.getSurmixlevString(this.ltrtsurmixlev))));
                s.add(new DefaultMutableTreeNode(new KVP("lorosurmixlev", this.lorosurmixlev, "Lo/Ro surround mix level: " + EAC3SyncFrame.getSurmixlevString(this.lorosurmixlev))));
            }
            if (this.lfeon != 0) {
                s.add(new DefaultMutableTreeNode(new KVP("lfemixlevcode", this.lfemixlevcode, "LFE mix level code " + EAC3SyncFrame.doesExistString(this.lfemixlevcode))));
                if (this.lfemixlevcode != 0) {
                    s.add(new DefaultMutableTreeNode(new KVP("lfemixlevcod", this.lfemixlevcod, "LFE mix level (dB): " + (10 - this.lfemixlevcod))));
                }
            }
            if (this.strmtyp == 0) {
                s.add(new DefaultMutableTreeNode(new KVP("pgmscle", this.pgmscle, "Programme scale factor " + EAC3SyncFrame.doesExistString(this.pgmscle))));
                if (this.pgmscle != 0) {
                    s.add(new DefaultMutableTreeNode(new KVP("pgmscl", this.pgmscl, "Programme scale factor: " + EAC3SyncFrame.getProgrammeScaleFactorString(this.pgmscl))));
                }
                if (this.acmod == 0) {
                    s.add(new DefaultMutableTreeNode(new KVP("pgmscl2e", this.pgmscl2e, "Programme scale factor #2 " + EAC3SyncFrame.doesExistString(this.pgmscl2e))));
                    if (this.pgmscl2e != 0) {
                        s.add(new DefaultMutableTreeNode(new KVP("pgmscl2", this.pgmscl2, "Programme scale factor #2: " + EAC3SyncFrame.getProgrammeScaleFactorString(this.pgmscl2))));
                    }
                }
                s.add(new DefaultMutableTreeNode(new KVP("extpgmscle", this.extpgmscle, "External programme scale factor " + EAC3SyncFrame.doesExistString(this.extpgmscle))));
                if (this.extpgmscle != 0) {
                    this.extpgmscl = this.bs.readBits(6);
                    s.add(new DefaultMutableTreeNode(new KVP("extpgmscl", this.extpgmscl, "External programme scale factor: " + EAC3SyncFrame.getProgrammeScaleFactorString(this.extpgmscl))));
                }
                s.add(new DefaultMutableTreeNode(new KVP("mixdef", this.mixdef, "Mix control type: " + EAC3SyncFrame.getMixControlTypeString(this.mixdef))));
                if (this.mixdef == 1) {
                    s.add(new DefaultMutableTreeNode(new KVP("premixcmpsel", this.premixcmpsel, null)));
                    s.add(new DefaultMutableTreeNode(new KVP("drcsrc", this.drcsrc, null)));
                    s.add(new DefaultMutableTreeNode(new KVP("premixcmpscl", this.premixcmpscl, null)));
                } else if (this.mixdef == 2) {
                    s.add(new DefaultMutableTreeNode(new KVP("mixdata", this.mixdata, null)));
                } else if (this.mixdef == 3) {
                    s.add(new DefaultMutableTreeNode(new KVP("mixdeflen", this.mixdeflen, "Length of mixing parameter data field: " + (this.mixdeflen + 2) + " bytes")));
                    s.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("mixing option 4")));
                }
                if (this.acmod < 2) {
                    s.add(new DefaultMutableTreeNode(new KVP("paninfoe", this.paninfoe, "Pan information " + EAC3SyncFrame.doesExistString(this.paninfoe))));
                    if (this.paninfoe != 0) {
                        s.add(new DefaultMutableTreeNode(new KVP("panmean", this.panmean, "Pan mean direction index: " + (double)this.panmean * 1.5 + " degrees")));
                        s.add(new DefaultMutableTreeNode(new KVP("paninfo", this.paninfo, "paninfo - reserved")));
                    }
                    if (this.acmod == 0) {
                        s.add(new DefaultMutableTreeNode(new KVP("paninfo2e", this.paninfo2e, "Pan information #2 " + EAC3SyncFrame.doesExistString(this.paninfo2e))));
                        if (this.paninfo2e != 0) {
                            s.add(new DefaultMutableTreeNode(new KVP("panmean2", this.panmean2, "Pan mean direction index: " + (double)this.panmean2 * 1.5 + " degrees")));
                            s.add(new DefaultMutableTreeNode(new KVP("paninfo2", this.paninfo2, "paninfo2 - reserved")));
                        }
                    }
                }
                s.add(new DefaultMutableTreeNode(new KVP("frmmixcfginfoe", this.frmmixcfginfoe, "Frame mixing configuration information " + EAC3SyncFrame.doesExistString(this.frmmixcfginfoe))));
                if (this.frmmixcfginfoe != 0) {
                    if (this.numblkscod == 0) {
                        s.add(new DefaultMutableTreeNode(new KVP("blkmixcfginfo", this.blkmixcfginfo[0], "Block mixing configuration information")));
                    } else {
                        int number_of_blocks_per_sync_frame = EAC3SyncFrame.getNumBlocks(this.numblkscod);
                        for (int blk = 0; blk < number_of_blocks_per_sync_frame; ++blk) {
                            s.add(new DefaultMutableTreeNode(new KVP("blkmixcfginfoe[" + blk + "]", this.blkmixcfginfoe[blk], "Block mixing configuration information[" + blk + "] " + EAC3SyncFrame.doesExistString(this.blkmixcfginfoe[blk]))));
                            if (this.blkmixcfginfoe[blk] == 0) continue;
                            s.add(new DefaultMutableTreeNode(new KVP("blkmixcfginfo[" + blk + "]", this.blkmixcfginfo[blk], "Block mixing configuration information")));
                        }
                    }
                }
            }
            s.add(new DefaultMutableTreeNode(new KVP("infomdate", this.infomdate, "Informational metadata " + EAC3SyncFrame.doesExistString(this.infomdate))));
            if (this.infomdate != 0) {
                s.add(new DefaultMutableTreeNode(new KVP("bsmod", this.bsmod, "Bit stream mode: " + EAC3SyncFrame.getBsModString(this.bsmod, this.acmod))));
                s.add(new DefaultMutableTreeNode(new KVP("copyrightb", this.copyrightb, "Copyright bit: " + (this.copyrightb == 1 ? "information in the bit stream is indicated as protected by copyright" : "information is not indicated as protected"))));
                s.add(new DefaultMutableTreeNode(new KVP("origbs", this.origbs, this.origbs == 1 ? "original bit stream" : "copy of another bit stream")));
                if (this.acmod == 2) {
                    s.add(new DefaultMutableTreeNode(new KVP("dsurmod", this.dsurmod, "Dolby Surround mode: " + EAC3SyncFrame.getDsurmodString(this.dsurmod))));
                    s.add(new DefaultMutableTreeNode(new KVP("dheadphonmod", this.dheadphonmod, "Dolby Headphone mode: " + EAC3SyncFrame.getDheadphonmodString(this.dheadphonmod))));
                }
                if (this.acmod >= 6) {
                    s.add(new DefaultMutableTreeNode(new KVP("dsurexmod", this.dsurexmod, "Dolby Surround EX mode: " + EAC3SyncFrame.getDsurexmodString(this.dsurexmod))));
                }
                s.add(new DefaultMutableTreeNode(new KVP("audprodie", this.audprodie, "Audio production information " + EAC3SyncFrame.doesExistString(this.audprodie))));
                if (this.audprodie != 0) {
                    s.add(new DefaultMutableTreeNode(new KVP("mixlevel", this.mixlevel, "Mixing level: " + (80 + this.mixlevel) + " dB")));
                    s.add(new DefaultMutableTreeNode(new KVP("roomtyp", "Room type: " + this.roomtyp, EAC3SyncFrame.getRoomTypeString(this.roomtyp))));
                    s.add(new DefaultMutableTreeNode(new KVP("adconvtyp", this.adconvtyp, "A/D converter type: " + (this.adconvtyp == 1 ? "HDCD" : "standard"))));
                }
                if (this.acmod == 0) {
                    s.add(new DefaultMutableTreeNode(new KVP("mixdata", this.mixdata, null)));
                    this.audprodi2e = this.bs.readBits(1);
                    if (this.audprodi2e != 0) {
                        s.add(new DefaultMutableTreeNode(new KVP("mixlevel2", this.mixlevel2, "peak mixing level during the final audio mixing session: " + (80 + this.mixlevel2) + " dB")));
                        s.add(new DefaultMutableTreeNode(new KVP("roomtyp2", this.roomtyp2, EAC3SyncFrame.getRoomTypeString(this.roomtyp))));
                        s.add(new DefaultMutableTreeNode(new KVP("adconvtyp2", this.adconvtyp2, "A/D converter type: " + (this.adconvtyp2 == 1 ? "HDCD" : "standard"))));
                    }
                }
                if (this.fscod < 3) {
                    s.add(new DefaultMutableTreeNode(new KVP("sourcefscod", this.sourcefscod, "Source sample rate code" + (this.sourcefscod == 1 ? " the source material was sampled at twice the rate indicated by fscod" : " the source material was NOT sampled at twice the rate indicated by fscod"))));
                }
                if (this.strmtyp == 0 && this.numblkscod != 3) {
                    s.add(new DefaultMutableTreeNode(new KVP("convsync", this.convsync, "Converter synchronization flag. This bit is used for synchronization by a device that converts an Enhanced AC-3 bit stream to a bit stream compliant with a legacy AC-3 decoder")));
                }
                if (this.strmtyp == 2) {
                    if (this.numblkscod == 3) {
                        s.add(new DefaultMutableTreeNode(new KVP("blkid", this.blkid, "Block identification: the first block in this Enhanced AC-3 frame was the first block in the original standard AC-3 frame: implicit because numblkscod == 0x3 (6 blocks per frame)")));
                    } else {
                        s.add(new DefaultMutableTreeNode(new KVP("blkid", this.blkid, "Block identification: " + (this.blkid == 1 ? "the first block in this Enhanced AC-3 frame was the first block in the original standard AC-3 frame" : "the first block in this Enhanced AC-3 frame was NOT the first block in the original standard AC-3 frame"))));
                    }
                    if (this.blkid != 0) {
                        s.add(new DefaultMutableTreeNode(new KVP("frmsizecod", this.frmsizecod, "Frame size code: " + EAC3SyncFrame.getFrmsizecodString(this.fscod, this.frmsizecod))));
                    }
                }
                this.addbsie = this.bs.readBits(1);
                s.add(new DefaultMutableTreeNode(new KVP("addbsie", this.addbsie, this.addbsie == 1 ? "Additional bit stream information exists" : "Additional bit stream information does not exist")));
                if (this.addbsie != 0) {
                    s.add(new DefaultMutableTreeNode(new KVP("addbsil", this.addbsil, "Additional bit stream information length")));
                }
            }
        }
        return s;
    }

    public static String getMixControlTypeString(int mixdef) {
        String[] desc = new String[]{"mixing option 1, no additional bits", "mixing option 2, 5 bits", "mixing option 3, 12 bits reserved", "mixing option 4, 16-264 bits reserved by mixdeflen"};
        return desc[mixdef];
    }

    public static String getProgrammeScaleFactorString(int pgmscl) {
        if (pgmscl == 0) {
            return "mute";
        }
        return pgmscl - 51 + " dB";
    }

    public static String getStreamTypeString(int strmtyp) {
        switch (strmtyp) {
            case 0: {
                return "Type 0: These frames comprise an independent stream or substream. The programme may be decoded independently of any other substreams that might exist in the bit stream.";
            }
            case 1: {
                return "Type 1: These frames comprise a dependent substream. The programme must be decoded in conjunction with the independent substream with which it is associated.";
            }
            case 2: {
                return "Type 2: These frames comprise an independent stream or substream that was previously coded in AC-3. Type 2 streams must be independently decodable, and may not have any dependent streams associated with them.";
            }
            case 3: {
                return "Type 3: Reserved";
            }
        }
        return "illegal value";
    }

    public static String getNumblkscodString(int numblkscod) {
        switch (numblkscod) {
            case 0: {
                return "1 block per syncframe";
            }
            case 1: {
                return "2 blocks per syncframe";
            }
            case 2: {
                return "3 blocks per syncframe";
            }
            case 3: {
                return "6 blocks per syncframe";
            }
        }
        return "illegal value";
    }

    public static String getReducedSampleRateCodeString(int fscod2) {
        switch (fscod2) {
            case 0: {
                return "24 kHz";
            }
            case 1: {
                return "22,05 kHz";
            }
            case 2: {
                return "16 kHz";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "illegal value";
    }

    public static int getNumBlocks(int numblkscod) {
        switch (numblkscod) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }

    public int getStrmtyp() {
        return this.strmtyp;
    }

    public int getLfemixlevcode() {
        return this.lfemixlevcode;
    }

    public int getLfemixlevcod() {
        return this.lfemixlevcod;
    }

    public int getSubstreamid() {
        return this.substreamid;
    }

    public int getFrmsiz() {
        return this.frmsiz;
    }

    public int getFscod2() {
        return this.fscod2;
    }

    public int getNumblkscod() {
        return this.numblkscod;
    }

    public int getChanmape() {
        return this.chanmape;
    }

    public int getChanmap() {
        return this.chanmap;
    }

    public int getMixmdate() {
        return this.mixmdate;
    }

    public int getPgmscle() {
        return this.pgmscle;
    }

    public int getPgmscl() {
        return this.pgmscl;
    }

    public int getPgmscl2e() {
        return this.pgmscl2e;
    }

    public int getPgmscl2() {
        return this.pgmscl2;
    }

    public int getExtpgmscle() {
        return this.extpgmscle;
    }

    public int getExtpgmscl() {
        return this.extpgmscl;
    }

    public int getMixdef() {
        return this.mixdef;
    }

    public int getPremixcmpsel() {
        return this.premixcmpsel;
    }

    public int getDrcsrc() {
        return this.drcsrc;
    }

    public int getPremixcmpscl() {
        return this.premixcmpscl;
    }

    public int getMixdata() {
        return this.mixdata;
    }

    public int getMixdeflen() {
        return this.mixdeflen;
    }

    public int getPaninfoe() {
        return this.paninfoe;
    }

    public int getPanmean() {
        return this.panmean;
    }

    public int getPaninfo() {
        return this.paninfo;
    }

    public int getPaninfo2e() {
        return this.paninfo2e;
    }

    public int getPanmean2() {
        return this.panmean2;
    }

    public int getPaninfo2() {
        return this.paninfo2;
    }

    public int getFrmmixcfginfoe() {
        return this.frmmixcfginfoe;
    }

    public int[] getBlkmixcfginfo() {
        return this.blkmixcfginfo;
    }

    public int[] getBlkmixcfginfoe() {
        return this.blkmixcfginfoe;
    }

    public int getInfomdate() {
        return this.infomdate;
    }

    public int getAdconvtyp2() {
        return this.adconvtyp2;
    }

    public int getSourcefscod() {
        return this.sourcefscod;
    }

    public int getBlkid() {
        return this.blkid;
    }

    public int getConvsync() {
        return this.convsync;
    }
}

