/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackListener;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.AncillaryData;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.AudioAccessUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.AudioPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.UECP;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;

public class Audio138183Handler
extends GeneralPesHandler
implements ImageSource {
    static final int PIX_PER_SEC = 500;
    static final int LEFT_MARGIN = 60;
    static final int LEGEND_HEIGHT = 20;
    static final int GRAPH_HEIGHT = 400;
    private static final Logger logger = Logger.getLogger(Audio138183Handler.class.getName());
    private byte[] rdsData = new byte[0];
    private final List<AudioAccessUnit> audioAccessUnits = new ArrayList<AudioAccessUnit>();
    private SwingPlayer swPlayer = null;
    private KVP kvp = null;
    private final int ancillaryDataIdentifier;

    public Audio138183Handler(int ancillaryDataidentifier) {
        this.ancillaryDataIdentifier = ancillaryDataidentifier;
    }

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        AudioPESDataField audioPes = new AudioPESDataField(pesData);
        this.pesPackets.add(audioPes);
        this.copyIntoBuf(audioPes);
        ArrayList<AudioAccessUnit> accessUnits = new ArrayList<AudioAccessUnit>();
        int i = this.bufStart;
        while (i < this.bufEnd && i >= 0) {
            if ((i = Audio138183Handler.indexOfSyncWord(this.pesDataBuffer, i)) < 0 || i + 4 > this.bufEnd) continue;
            AudioAccessUnit frame = new AudioAccessUnit(this.pesDataBuffer, i, audioPes.getPesHeader().getPts());
            int unitLen = frame.getFrameSize();
            if (unitLen < 0) {
                ++i;
                continue;
            }
            if (i + unitLen + 2 < this.bufEnd) {
                int nextIndex = Audio138183Handler.indexOfSyncWord(this.pesDataBuffer, i + unitLen);
                if (nextIndex == i + unitLen) {
                    accessUnits.add(frame);
                    i = nextIndex;
                    this.bufStart = nextIndex;
                    continue;
                }
                if (nextIndex == -1) {
                    this.bufStart = i;
                    break;
                }
                logger.fine("Sync error parsing PES audio data, pesPacket started at TSPacket:" + pesData.getStartPacketNo());
                this.bufStart = nextIndex;
                i = nextIndex;
                continue;
            }
            if (i + unitLen == this.bufEnd) {
                accessUnits.add(frame);
                this.bufStart = this.bufEnd;
                break;
            }
            this.bufStart = i;
            break;
        }
        this.audioAccessUnits.addAll(accessUnits);
        if ((this.ancillaryDataIdentifier & 0x40) != 0) {
            for (AudioAccessUnit accessUnit : accessUnits) {
                AncillaryData ancillaryData = accessUnit.getAncillaryData();
                if (ancillaryData == null || ancillaryData.getSync() != 253 || ancillaryData.getDataFieldLength() == 0) continue;
                byte[] b = ancillaryData.getDataByte();
                byte[] newRdsData = new byte[this.rdsData.length + b.length];
                System.arraycopy(this.rdsData, 0, newRdsData, 0, this.rdsData.length);
                System.arraycopy(b, 0, newRdsData, this.rdsData.length, b.length);
                this.rdsData = newRdsData;
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        this.kvp = new KVP("PES Data").addImageSource(this, "audio");
        if (this.swPlayer == null) {
            objectMenu = new JMenuItem("Play Audio");
            objectMenu.setActionCommand("play");
            this.kvp.setSubMenuAndOwner(objectMenu, this);
        } else {
            objectMenu = new JMenuItem("Stop Audio");
            objectMenu.setActionCommand("stop");
            this.kvp.setSubMenuAndOwner(objectMenu, this);
        }
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(this.kvp);
        Utils.addListJTree(s, this.pesPackets, modus, "PES Packets");
        Utils.addListJTree(s, this.audioAccessUnits, modus, "Audio Access Units");
        if ((this.ancillaryDataIdentifier & 0x40) != 0) {
            DefaultMutableTreeNode rdsNode = new DefaultMutableTreeNode(new KVP("RDS"));
            s.add(rdsNode);
            rdsNode.add(new DefaultMutableTreeNode(new KVP("RDS Data", this.rdsData, null)));
            UECP uecp = new UECP(this.rdsData);
            rdsNode.add(uecp.getJTreeNode(modus));
        }
        return s;
    }

    private static int indexOfSyncWord(byte[] source, int fromIndex) {
        if (fromIndex >= source.length) {
            return -1;
        }
        int max = source.length - 1;
        for (int i = fromIndex; i < max; ++i) {
            if (source[i] != -1) {
                while (++i <= max && source[i] != -1) {
                }
            }
            if (i >= max || (source[i + 1] & 0xF0) != 240) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BufferedImage getImage() {
        int channel;
        if (this.audioAccessUnits.isEmpty()) {
            return null;
        }
        AudioAccessUnit firstUnit = this.audioAccessUnits.get(0);
        int unitSize = firstUnit.getFrameSize();
        int samplingFreq = firstUnit.getSamplingFrequency();
        int channels = firstUnit.getMode() == 3 ? 1 : 2;
        int noUnits = this.audioAccessUnits.size();
        byte[] tmp = this.getESData(unitSize);
        ByteArrayInputStream is = new ByteArrayInputStream(tmp);
        Decoder decoder = new Decoder();
        SampleBuffer output = null;
        int height = channels * 420;
        long noSamples = (long)noUnits * 1152L;
        int width = (int)(noSamples * 500L / (long)samplingFreq);
        int lengthSecs = (int)(noSamples / (long)samplingFreq);
        BufferedImage img = new BufferedImage(width + 60, height, 1);
        Graphics2D gd = img.createGraphics();
        gd.setColor(Color.BLACK);
        gd.fillRect(0, 0, width + 60, height);
        for (channel = 0; channel < channels; ++channel) {
            gd.setColor(Color.WHITE);
            gd.fillRect(0, 400 * (1 + channel) + 20 * channel, width + 60, 20);
            gd.setColor(Color.GRAY);
            for (int line = -30000; line <= 30000; line += 5000) {
                int y = Audio138183Handler.getY(channel, line);
                gd.drawLine(60, y, 60 + width, y);
                String label = "" + line;
                FontMetrics metrics = gd.getFontMetrics();
                int adv = metrics.stringWidth(label);
                gd.drawString(label, 60 - adv - 5, y);
            }
            for (int t = 0; t <= lengthSecs; ++t) {
                gd.setColor(Color.GRAY);
                gd.drawLine(t * 500 + 60, Audio138183Handler.getY(channel, Short.MAX_VALUE), t * 500 + 60, Audio138183Handler.getY(channel, Short.MIN_VALUE));
                gd.setColor(Color.BLACK);
                String label = t + " sec";
                gd.drawString(label, t * 500 + 60, (1 + channel) * 420 - 4);
            }
        }
        gd.setColor(Color.RED);
        for (channel = 0; channel < channels; ++channel) {
            gd.drawLine(60, Audio138183Handler.getY(channel, 0), 60 + width, Audio138183Handler.getY(channel, 0));
        }
        Bitstream stream = new Bitstream(is);
        int runningX = 0;
        int[] minVal = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        int[] maxVal = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        int sampleNo = 0;
        try {
            while (true) {
                Header header;
                if ((header = stream.readFrame()) == null) {
                    return img;
                }
                if (output == null) {
                    int freq = header.frequency();
                    output = new SampleBuffer(freq, channels);
                    decoder.setOutputBuffer(output);
                }
                SampleBuffer decoderOutput = (SampleBuffer)decoder.decodeFrame(header, stream);
                short[] buf = decoderOutput.getBuffer();
                gd.setColor(Color.GREEN);
                for (int i = 0; i < 1152; ++i) {
                    int newX;
                    for (int channel2 = 0; channel2 < channels; ++channel2) {
                        short s = buf[i * channels + channel2];
                        maxVal[channel2] = Math.max(s, maxVal[channel2]);
                        minVal[channel2] = Math.min(s, minVal[channel2]);
                    }
                    if ((newX = (int)((long)(++sampleNo) * 500L / (long)samplingFreq)) <= runningX) continue;
                    for (int channel3 = 0; channel3 < channels; ++channel3) {
                        gd.drawLine(runningX + 60, Audio138183Handler.getY(channel3, minVal[channel3]), runningX + 60, Audio138183Handler.getY(channel3, maxVal[channel3]));
                        minVal[channel3] = Integer.MAX_VALUE;
                        maxVal[channel3] = Integer.MIN_VALUE;
                    }
                    runningX = newX;
                }
                stream.closeFrame();
            }
        }
        catch (JavaLayerException e) {
            logger.log(Level.WARNING, "error while decoding sound for drawing", e);
            return img;
        }
    }

    private static int getY(int channel, int sample) {
        int t = (int)((long)sample * 400L / 65534L);
        return 200 + channel * 420 - t;
    }

    private byte[] getESData(int unitSize) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.audioAccessUnits.size() * unitSize);
        for (AudioAccessUnit unit : this.audioAccessUnits) {
            byteBuffer.put(unit.getData(), unit.getStart(), unit.getFrameSize());
        }
        byte[] tmp = byteBuffer.array();
        return tmp;
    }

    public void play() {
        this.swPlayer = new SwingPlayer();
        this.swPlayer.execute();
        JMenuItem objectMenu = new JMenuItem("Stop Audio");
        objectMenu.setActionCommand("stop");
        this.kvp.setSubMenuAndOwner(objectMenu, this);
    }

    public void stop() {
        this.swPlayer.stop();
        JMenuItem objectMenu = new JMenuItem("Play Audio");
        objectMenu.setActionCommand("play");
        this.kvp.setSubMenuAndOwner(objectMenu, this);
    }

    public List<AudioAccessUnit> getAudioAccessUnits() {
        return this.audioAccessUnits;
    }

    class SwingPlayer
    extends SwingWorker<Void, Void> {
        AdvancedPlayer player;

        SwingPlayer() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                AudioAccessUnit firstUnit = Audio138183Handler.this.audioAccessUnits.get(0);
                int unitSize = firstUnit.getFrameSize();
                byte[] esData = Audio138183Handler.this.getESData(unitSize);
                ByteArrayInputStream is = new ByteArrayInputStream(esData);
                AudioDevice dev = FactoryRegistry.systemRegistry().createAudioDevice();
                this.player = new AdvancedPlayer(is, dev);
                this.player.setPlayBackListener(new PlaybackListener(this){});
                this.player.play();
            }
            catch (JavaLayerException e) {
                logger.log(Level.WARNING, "error while playing sound", e);
            }
            return null;
        }

        @Override
        protected void done() {
            JMenuItem objectMenu = new JMenuItem("Play Audio");
            objectMenu.setActionCommand("play");
            Audio138183Handler.this.kvp.setSubMenu(objectMenu);
        }

        public void stop() {
            this.player.stop();
        }
    }
}

