/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.AncillaryData;
import nl.digitalekabeltelevisie.util.Utils;

public class AudioAccessUnit
implements TreeNode {
    private final long pts;
    private final int syncWord;
    private final int id;
    private final int layer;
    private final int protection_bit;
    private final int bit_rate_index;
    private final int sampling_frequency_index;
    private final int padding_bit;
    private final int private_bit;
    private final int mode;
    private final int mode_extension;
    private final int copyright;
    private final int original_home;
    private final int emphasis;
    private final byte[] data;
    private final int start;
    public static final int MPEG2_LSF = 0;
    public static final int MPEG25_LSF = 2;
    public static final int MPEG1 = 1;
    public static final int STEREO = 0;
    public static final int JOINT_STEREO = 1;
    public static final int DUAL_CHANNEL = 2;
    public static final int SINGLE_CHANNEL = 3;
    public static final int FOURTYFOUR_POINT_ONE = 0;
    public static final int FOURTYEIGHT = 1;
    public static final int THIRTYTWO = 2;
    public static final int[][][] bitrates = new int[][][]{new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}, new int[][]{{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}}, new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}};
    public static final int[][] frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}, {11025, 12000, 8000, 1}};

    public AudioAccessUnit(byte[] data, int offset, long pts) {
        this.data = data;
        this.start = offset;
        this.pts = pts;
        int i = offset;
        this.syncWord = Utils.getInt(data, i, 2, 65520) >> 4;
        this.id = Utils.getInt(data, i + 1, 1, 8) >> 3;
        this.layer = Utils.getInt(data, i + 1, 1, 6) >> 1;
        this.protection_bit = Utils.getInt(data, i + 1, 1, 1);
        this.bit_rate_index = Utils.getInt(data, i + 2, 1, 240) >> 4;
        this.sampling_frequency_index = Utils.getInt(data, i + 2, 1, 12) >> 2;
        this.padding_bit = Utils.getInt(data, i + 2, 1, 2) >> 1;
        this.private_bit = Utils.getInt(data, i + 2, 1, 1);
        this.mode = Utils.getInt(data, i + 3, 1, 192) >> 6;
        this.mode_extension = Utils.getInt(data, i + 3, 1, 48) >> 4;
        this.copyright = Utils.getInt(data, i + 3, 1, 8) >> 3;
        this.original_home = Utils.getInt(data, i + 3, 1, 4) >> 2;
        this.emphasis = Utils.getInt(data, i + 3, 1, 3);
        if (this.protection_bit == 0) {
            // empty if block
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("Frame"));
        s.add(new DefaultMutableTreeNode(new KVP("data", this.data, this.start, this.getFrameSize(), null)));
        s.add(new DefaultMutableTreeNode(new KVP("len", this.getFrameSize(), null)));
        s.add(new DefaultMutableTreeNode(new KVP("pts", this.pts, Utils.printTimebase90kHz(this.pts))));
        s.add(new DefaultMutableTreeNode(new KVP("syncWord", this.syncWord, null)));
        s.add(new DefaultMutableTreeNode(new KVP("id", this.id, this.id == 1 ? "MPEG audio" : "extension to lower sampling frequencies")));
        s.add(new DefaultMutableTreeNode(new KVP("layer", this.layer, AudioAccessUnit.getLayerString(this.layer))));
        s.add(new DefaultMutableTreeNode(new KVP("protection_bit", this.protection_bit, this.protection_bit == 1 ? "no redundancy" : "redundancy has been added")));
        s.add(new DefaultMutableTreeNode(new KVP("bit_rate_index", this.bit_rate_index, AudioAccessUnit.getBitrateString(this.id, this.layer, this.bit_rate_index))));
        s.add(new DefaultMutableTreeNode(new KVP("sampling_frequency", this.sampling_frequency_index, AudioAccessUnit.getSamplingFrequencyString(this.id, this.sampling_frequency_index))));
        s.add(new DefaultMutableTreeNode(new KVP("padding_bit", this.padding_bit, this.padding_bit == 1 ? "frame contains an additional slot to adjust the mean bitrate to the sampling frequency" : "No padding")));
        s.add(new DefaultMutableTreeNode(new KVP("private_bit", this.private_bit, null)));
        s.add(new DefaultMutableTreeNode(new KVP("mode", this.mode, AudioAccessUnit.getModeString(this.mode))));
        s.add(new DefaultMutableTreeNode(new KVP("mode_extension", this.mode_extension, AudioAccessUnit.getModeExtensionString(this.layer, this.mode, this.mode_extension))));
        s.add(new DefaultMutableTreeNode(new KVP("copyright", this.copyright, this.copyright == 1 ? "copyright protected" : "no copyright")));
        s.add(new DefaultMutableTreeNode(new KVP("original/home", this.original_home, this.original_home == 1 ? "original" : "copy")));
        s.add(new DefaultMutableTreeNode(new KVP("emphasis", this.emphasis, AudioAccessUnit.getEmphasisString(this.emphasis))));
        if (this.protection_bit == 0) {
            s.add(new DefaultMutableTreeNode(new KVP("crc_check", Utils.getInt(this.data, this.start + 4, 2, 65535), null)));
        }
        return s;
    }

    public static String getModeExtensionString(int layer, int mode, int mode_extension) {
        if (mode != 1) {
            return null;
        }
        if (layer == 1) {
            switch (mode_extension) {
                case 0: {
                    return "intensity_stereo: off, ms_stereo: off";
                }
                case 1: {
                    return "intensity_stereo: on, ms_stereo: off";
                }
                case 2: {
                    return "intensity_stereo: off, ms_stereo: on";
                }
                case 3: {
                    return "intensity_stereo: on, ms_stereo: on";
                }
            }
            return "Illegal value";
        }
        switch (mode_extension) {
            case 0: {
                return "subbands 4-31 in intensity_stereo, bound==4";
            }
            case 1: {
                return "subbands 8-31 in intensity_stereo, bound==8";
            }
            case 2: {
                return "subbands 12-31 in intensity_stereo, bound==12";
            }
            case 3: {
                return "subbands 16-31 in intensity_stereo, bound==16";
            }
        }
        return "Illegal value";
    }

    public static String getLayerString(int layer) {
        switch (layer) {
            case 1: {
                return "Layer III";
            }
            case 2: {
                return "Layer II";
            }
            case 3: {
                return "Layer I";
            }
        }
        return "reserved";
    }

    public static String getSamplingFrequencyString(int id, int sampling_frequency_index) {
        if (id == 1) {
            switch (sampling_frequency_index) {
                case 0: {
                    return "44.1 kHz";
                }
                case 1: {
                    return "48 kHz";
                }
                case 2: {
                    return "32 kHz";
                }
            }
            return "reserved";
        }
        switch (sampling_frequency_index) {
            case 0: {
                return "22.05 kHz";
            }
            case 1: {
                return "24 kHz";
            }
            case 2: {
                return "16 kHz";
            }
        }
        return "reserved";
    }

    public int getSamplingFrequency() {
        return AudioAccessUnit.getSamplingFrequency(this.id, this.sampling_frequency_index);
    }

    public static int getSamplingFrequency(int id, int sampling_frequency_index) {
        if (id == 1) {
            switch (sampling_frequency_index) {
                case 0: {
                    return 44100;
                }
                case 1: {
                    return 48000;
                }
                case 2: {
                    return 32000;
                }
            }
            throw new IllegalArgumentException("id:" + id + ",sampling_frequency_index:" + sampling_frequency_index);
        }
        switch (sampling_frequency_index) {
            case 0: {
                return 22050;
            }
            case 1: {
                return 24000;
            }
            case 2: {
                return 16000;
            }
        }
        throw new IllegalArgumentException("id:" + id + ",sampling_frequency_index:" + sampling_frequency_index);
    }

    public static String getModeString(int mode) {
        switch (mode) {
            case 0: {
                return "stereo";
            }
            case 1: {
                return "joint_stereo (intensity_stereo and/or ms_stereo)";
            }
            case 2: {
                return "dual_channel";
            }
            case 3: {
                return "single_channel";
            }
        }
        return "illegal value";
    }

    public static String getEmphasisString(int emphasis) {
        switch (emphasis) {
            case 0: {
                return "no emphasis";
            }
            case 1: {
                return "50/15 microsec. emphasis";
            }
            case 2: {
                return "reserved";
            }
            case 3: {
                return "CCITT J.17";
            }
        }
        return "illegal value";
    }

    public static String getBitrateString(int id, int layer, int bit_rate_index) {
        if (id == 1) {
            switch (layer) {
                case 1: {
                    switch (bit_rate_index) {
                        case 0: {
                            return "free format";
                        }
                        case 1: {
                            return "32 kbit/s";
                        }
                        case 2: {
                            return "40 kbit/s";
                        }
                        case 3: {
                            return "48 kbit/s";
                        }
                        case 4: {
                            return "56 kbit/s";
                        }
                        case 5: {
                            return "64 kbit/s";
                        }
                        case 6: {
                            return "80 kbit/s";
                        }
                        case 7: {
                            return "96 kbit/s";
                        }
                        case 8: {
                            return "112 kbit/s";
                        }
                        case 9: {
                            return "128 kbit/s";
                        }
                        case 10: {
                            return "160 kbit/s";
                        }
                        case 11: {
                            return "192 kbit/s";
                        }
                        case 12: {
                            return "224 kbit/s";
                        }
                        case 13: {
                            return "256 kbit/s";
                        }
                        case 14: {
                            return "320 kbit/s";
                        }
                    }
                    return "Illegal combination layer/ bitrate";
                }
                case 2: {
                    switch (bit_rate_index) {
                        case 0: {
                            return "free format";
                        }
                        case 1: {
                            return "32 kbit/s";
                        }
                        case 2: {
                            return "48 kbit/s";
                        }
                        case 3: {
                            return "56 kbit/s";
                        }
                        case 4: {
                            return "64 kbit/s";
                        }
                        case 5: {
                            return "80 kbit/s";
                        }
                        case 6: {
                            return "96 kbit/s";
                        }
                        case 7: {
                            return "112 kbit/s";
                        }
                        case 8: {
                            return "128 kbit/s";
                        }
                        case 9: {
                            return "160 kbit/s";
                        }
                        case 10: {
                            return "192 kbit/s";
                        }
                        case 11: {
                            return "224 kbit/s";
                        }
                        case 12: {
                            return "256 kbit/s";
                        }
                        case 13: {
                            return "320 kbit/s";
                        }
                        case 14: {
                            return "384 kbit/s";
                        }
                    }
                    return "Illegal combination layer/ bitrate";
                }
                case 3: {
                    switch (bit_rate_index) {
                        case 0: {
                            return "free format";
                        }
                        case 1: {
                            return "32 kbit/s";
                        }
                        case 2: {
                            return "64 kbit/s";
                        }
                        case 3: {
                            return "96 kbit/s";
                        }
                        case 4: {
                            return "128 kbit/s";
                        }
                        case 5: {
                            return "160 kbit/s";
                        }
                        case 6: {
                            return "192 kbit/s";
                        }
                        case 7: {
                            return "224 kbit/s";
                        }
                        case 8: {
                            return "256 kbit/s";
                        }
                        case 9: {
                            return "288 kbit/s";
                        }
                        case 10: {
                            return "320 kbit/s";
                        }
                        case 11: {
                            return "352 kbit/s";
                        }
                        case 12: {
                            return "384 kbit/s";
                        }
                        case 13: {
                            return "416 kbit/s";
                        }
                        case 14: {
                            return "448 kbit/s";
                        }
                    }
                    return "Illegal combination layer/ bitrate";
                }
            }
            return "Illegal combination layer/ bitrate";
        }
        if (layer == 3) {
            switch (bit_rate_index) {
                case 0: {
                    return "free format";
                }
                case 1: {
                    return "32 kbit/s";
                }
                case 2: {
                    return "48 kbit/s";
                }
                case 3: {
                    return "56 kbit/s";
                }
                case 4: {
                    return "64 kbit/s";
                }
                case 5: {
                    return "80 kbit/s";
                }
                case 6: {
                    return "96 kbit/s";
                }
                case 7: {
                    return "112 kbit/s";
                }
                case 8: {
                    return "128 kbit/s";
                }
                case 9: {
                    return "144 kbit/s";
                }
                case 10: {
                    return "160 kbit/s";
                }
                case 11: {
                    return "176 kbit/s";
                }
                case 12: {
                    return "192 kbit/s";
                }
                case 13: {
                    return "224 kbit/s";
                }
                case 14: {
                    return "256 kbit/s";
                }
            }
            return "forbidden bit_rate_index";
        }
        switch (bit_rate_index) {
            case 0: {
                return "free format";
            }
            case 1: {
                return "8 kbit/s";
            }
            case 2: {
                return "16 kbit/s";
            }
            case 3: {
                return "24 kbit/s";
            }
            case 4: {
                return "32 kbit/s";
            }
            case 5: {
                return "40 kbit/s";
            }
            case 6: {
                return "48 kbit/s";
            }
            case 7: {
                return "56 kbit/s";
            }
            case 8: {
                return "64 kbit/s";
            }
            case 9: {
                return "80 kbit/s";
            }
            case 10: {
                return "96 kbit/s";
            }
            case 11: {
                return "112 kbit/s";
            }
            case 12: {
                return "128 kbit/s";
            }
            case 13: {
                return "144 kbit/s";
            }
            case 14: {
                return "160 kbit/s";
            }
        }
        return "forbidden bit_rate_index";
    }

    public int getBit_rate_index() {
        return this.bit_rate_index;
    }

    public int getCopyright() {
        return this.copyright;
    }

    public int getEmphasis() {
        return this.emphasis;
    }

    public int getId() {
        return this.id;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getMode_extension() {
        return this.mode_extension;
    }

    public int getOriginal_home() {
        return this.original_home;
    }

    public int getPadding_bit() {
        return this.padding_bit;
    }

    public int getPrivate_bit() {
        return this.private_bit;
    }

    public int getProtection_bit() {
        return this.protection_bit;
    }

    public long getPts() {
        return this.pts;
    }

    public int getSampling_frequency_index() {
        return this.sampling_frequency_index;
    }

    public int getSyncWord() {
        return this.syncWord;
    }

    public int getMode() {
        return this.mode;
    }

    public int getFrameSize() {
        int h_version = this.id;
        int javazoomLayer = 4 - this.layer;
        int framesize = -1;
        if (javazoomLayer == 1) {
            framesize = 12 * bitrates[h_version][0][this.bit_rate_index] / frequencies[h_version][this.sampling_frequency_index];
            if (this.padding_bit != 0) {
                ++framesize;
            }
            framesize <<= 2;
        } else if (javazoomLayer > 1) {
            framesize = 144 * bitrates[h_version][javazoomLayer - 1][this.bit_rate_index] / frequencies[h_version][this.sampling_frequency_index];
            if (h_version == 0 || h_version == 2) {
                framesize >>= 1;
            }
            if (this.padding_bit != 0) {
                ++framesize;
            }
        }
        return framesize;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStart() {
        return this.start;
    }

    public AncillaryData getAncillaryData() {
        return new AncillaryData(this.data, this.start, this.getFrameSize());
    }
}

