/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.Audio144963Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.PayloadLengthInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.PayloadMux;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.StreamMuxConfig;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class AudioMuxElement
implements TreeNode {
    private int muxConfigPresent;
    private int useSameStreamMux;
    private StreamMuxConfig streamMuxConfig;
    List<PayloadLengthInfo> payloadLengthInfoList = new ArrayList<PayloadLengthInfo>();
    BitSource localBitSource;
    List<PayloadMux> payloadMuxList = new ArrayList<PayloadMux>();

    public AudioMuxElement(BitSource bitSource, int muxConfigPresent, Audio144963Handler audio144963Handler) {
        this.localBitSource = new BitSource(bitSource);
        this.streamMuxConfig = audio144963Handler.getStreamMuxConfig();
        this.muxConfigPresent = muxConfigPresent;
        if (muxConfigPresent == 1) {
            this.useSameStreamMux = bitSource.readBits(1);
            if (this.useSameStreamMux != 1) {
                this.streamMuxConfig = new StreamMuxConfig(bitSource);
                audio144963Handler.setStreamMuxConfig(this.streamMuxConfig);
            }
        }
        if (this.streamMuxConfig != null && this.streamMuxConfig.getAudioMuxVersionA() == 0) {
            for (int i = 0; i <= this.streamMuxConfig.getNumSubFrames(); ++i) {
                PayloadLengthInfo payloadLengthInfo = new PayloadLengthInfo(bitSource, this.streamMuxConfig);
                this.payloadLengthInfoList.add(payloadLengthInfo);
                PayloadMux payloadMux = new PayloadMux(bitSource, this.streamMuxConfig, payloadLengthInfo);
                this.payloadMuxList.add(payloadMux);
            }
            if (this.streamMuxConfig.getOtherDataPresent() == 1) {
                // empty if block
            }
        }
        bitSource.skiptoByteBoundary();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AudioMuxElement(" + this.muxConfigPresent + ")"));
        if (this.muxConfigPresent == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("useSameStreamMux", this.useSameStreamMux, null)));
            if (this.useSameStreamMux != 1) {
                t.add(this.streamMuxConfig.getJTreeNode(modus));
            }
        }
        if (this.streamMuxConfig != null && this.streamMuxConfig.getAudioMuxVersionA() == 0) {
            Utils.addListJTree(t, this.payloadLengthInfoList, modus, "PayloadLengthInfoList");
            Utils.addListJTree(t, this.payloadMuxList, modus, "PayloadMuxList");
        }
        return t;
    }

    public int getMuxConfigPresent() {
        return this.muxConfigPresent;
    }

    public int getUseSameStreamMux() {
        return this.useSameStreamMux;
    }

    public StreamMuxConfig getStreamMuxConfig() {
        return this.streamMuxConfig;
    }

    public List<PayloadLengthInfo> getPayloadLengthInfoList() {
        return this.payloadLengthInfoList;
    }

    public List<PayloadMux> getPayloadMuxList() {
        return this.payloadMuxList;
    }
}

