/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.Audio144963Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.AudioMuxElement;
import nl.digitalekabeltelevisie.util.BitSource;

public class AudioSyncStream
implements TreeNode {
    private int syncword;
    private int audioMuxLengthBytes;
    private AudioMuxElement audioMuxElement;

    public AudioSyncStream(BitSource bitSource, Audio144963Handler audio144963Handler) {
        this.syncword = bitSource.readBits(11);
        this.audioMuxLengthBytes = bitSource.readBits(13);
        this.audioMuxElement = new AudioMuxElement(new BitSource(bitSource, this.audioMuxLengthBytes), 1, audio144963Handler);
        bitSource.advanceBytes(this.audioMuxLengthBytes);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AudioSyncStream"));
        t.add(new DefaultMutableTreeNode(new KVP("syncword", this.syncword, "should be 0x2B7")));
        t.add(new DefaultMutableTreeNode(new KVP("audioMuxLengthBytes", this.audioMuxLengthBytes, null)));
        t.add(this.audioMuxElement.getJTreeNode(modus));
        return t;
    }

    public int getAudioMuxLengthBytes() {
        return this.audioMuxLengthBytes;
    }

    public AudioMuxElement getAudioMuxElement() {
        return this.audioMuxElement;
    }
}

