/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;

public class GASpecificConfig
implements TreeNode {
    private int frameLength;
    private int dependsOnCoreCoder;
    int samplingFrequencyIndex;
    int channelConfiguration;
    int audioObjectType;
    private int coreCoderDelay;
    private int extensionFlag;
    private int layerNr;
    private static final Logger logger = Logger.getLogger(GASpecificConfig.class.getName());

    public GASpecificConfig(BitSource bitSource, int samplingFrequencyIndex, int channelConfiguration, int audioObjectType) {
        this.samplingFrequencyIndex = samplingFrequencyIndex;
        this.channelConfiguration = channelConfiguration;
        this.audioObjectType = audioObjectType;
        this.frameLength = bitSource.readBits(1);
        this.dependsOnCoreCoder = bitSource.readBits(1);
        if (this.dependsOnCoreCoder == 1) {
            this.coreCoderDelay = bitSource.readBits(14);
        }
        this.extensionFlag = bitSource.readBits(1);
        if (channelConfiguration == 0) {
            logger.warning("program_config_element not implemented");
        }
        if (audioObjectType == 6 || audioObjectType == 20) {
            this.layerNr = bitSource.readBits(3);
        }
        if (this.extensionFlag == 1) {
            logger.warning("extensionFlag ==1 not implemented");
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("GASpecificConfig"));
        t.add(new DefaultMutableTreeNode(new KVP("FrameLength", this.frameLength, null)));
        t.add(new DefaultMutableTreeNode(new KVP("DependsOnCoreCoder", this.dependsOnCoreCoder, null)));
        if (this.dependsOnCoreCoder == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("coreCoderDelay", this.coreCoderDelay, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("ExtensionFlag", this.extensionFlag, null)));
        if (this.channelConfiguration == 0) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("program_config_element")));
        }
        if (this.audioObjectType == 6 || this.audioObjectType == 20) {
            t.add(new DefaultMutableTreeNode(new KVP("layerNr", this.layerNr, null)));
        }
        if (this.extensionFlag == 1) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("extensionFlag ==1")));
        }
        return t;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public int getDependsOnCoreCoder() {
        return this.dependsOnCoreCoder;
    }

    public int getAudioObjectType() {
        return this.audioObjectType;
    }

    public int getCoreCoderDelay() {
        return this.coreCoderDelay;
    }

    public int getExtensionFlag() {
        return this.extensionFlag;
    }

    public int getLayerNr() {
        return this.layerNr;
    }
}

