/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.StreamMuxConfig;
import nl.digitalekabeltelevisie.util.BitSource;

public class PayloadLengthInfo
implements TreeNode {
    private int[] muxSlotLengthBytes = new int[64];
    private int[] muxSlotLengthCoded = new int[64];
    private StreamMuxConfig streamMuxConfig;

    public PayloadLengthInfo(BitSource bitSource, StreamMuxConfig streamMuxConfig) {
        this.streamMuxConfig = streamMuxConfig;
        if (streamMuxConfig.getAllStreamsSameTimeFraming() == 1) {
            int[][] streamID = streamMuxConfig.getStreamID();
            List<StreamMuxConfig.ProgramConfig> programConfigList = streamMuxConfig.getProgramConfigList();
            int[] frameLengthType = streamMuxConfig.getFrameLengthType();
            for (int prog = 0; prog <= streamMuxConfig.getNumProgram(); ++prog) {
                StreamMuxConfig.ProgramConfig programConfig = programConfigList.get(prog);
                for (int lay = 0; lay <= programConfig.getNumLayer(); ++lay) {
                    if (frameLengthType[streamID[prog][lay]] == 0) {
                        int tmp;
                        this.muxSlotLengthBytes[streamID[prog][lay]] = 0;
                        do {
                            tmp = bitSource.readBits(8);
                            int n = streamID[prog][lay];
                            this.muxSlotLengthBytes[n] = this.muxSlotLengthBytes[n] + tmp;
                        } while (tmp == 255);
                        continue;
                    }
                    if (frameLengthType[streamID[prog][lay]] != 5 && frameLengthType[streamID[prog][lay]] != 7 && frameLengthType[streamID[prog][lay]] != 3) continue;
                    this.muxSlotLengthCoded[streamID[prog][lay]] = bitSource.readBits(2);
                }
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("PayloadLengthInfo"));
        if (this.streamMuxConfig.getAllStreamsSameTimeFraming() == 1) {
            int[][] streamID = this.streamMuxConfig.getStreamID();
            List<StreamMuxConfig.ProgramConfig> programConfigList = this.streamMuxConfig.getProgramConfigList();
            int[] frameLengthType = this.streamMuxConfig.getFrameLengthType();
            for (int prog = 0; prog <= this.streamMuxConfig.getNumProgram(); ++prog) {
                StreamMuxConfig.ProgramConfig programConfig = programConfigList.get(prog);
                for (int lay = 0; lay <= programConfig.getNumLayer(); ++lay) {
                    if (frameLengthType[streamID[prog][lay]] != 0) continue;
                    t.add(new DefaultMutableTreeNode(new KVP("MuxSlotLengthBytes[streamID[" + prog + "][" + lay + "]]", this.muxSlotLengthBytes[streamID[prog][lay]], "streamID[" + prog + "][" + lay + "]]=" + streamID[prog][lay])));
                }
            }
        }
        return t;
    }

    public int[] getMuxSlotLengthBytes() {
        return this.muxSlotLengthBytes;
    }

    public int[] getMuxSlotLengthCoded() {
        return this.muxSlotLengthCoded;
    }
}

