/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.AudioSpecificConfig;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class StreamMuxConfig
implements TreeNode {
    private static final Logger logger = Logger.getLogger(StreamMuxConfig.class.getName());
    static LookUpList frameLengthTypeList = new LookUpList.Builder().add(0, "Payload with variable frame length. The payload length in bytes is directly specified with 8-bit codes in PayloadLengthInfo()").add(1, "Payload with fixed frame length. The payload length in bits is specified with frameLength in StreamMuxConfig()").add(2, "Reserved").add(3, "Payload for a CELP object with one of 2 kinds of frame length. The payload length is specified by two tableindices, namely CELPframeLengthTableIndex and MuxSlotLengthCoded").add(4, "Payload for a CELP or ER_CELP object with fixed frame length. CELPframeLengthTableIndex specifies the payload length").add(5, "Payload for an ER_CELP object with one of 4 kinds of frame length. The payload length is specified by two tableindices, namely CELPframeLengthTableIndex and MuxSlotLengthCoded").add(6, "Payload for a HVXC or ER_HVXC object with fixed frame length. HVXCframeLengthTableIndex specifies the payload length").add(7, "Payload for an HVXC or ER_HVXC object with one of 4 kinds of frame length. The payload length is specified by two table-indices, namely HVXCframeLengthTableIndex and MuxSlotLengthCoded").build();
    int[] progSIndx = new int[64];
    int[] laySIndx = new int[8];
    int[][] streamID;
    int[] frameLengthType = new int[16];
    int[] latmBufferFullness = new int[64];
    int audioMuxVersion;
    int audioMuxVersionA = 0;
    int allStreamsSameTimeFraming;
    int numSubFrames;
    int numProgram;
    int streamCnt;
    private List<ProgramConfig> programConfigList = new ArrayList<ProgramConfig>();
    private int otherDataPresent;
    BitSource localBitSource;
    private int crcCheckPresent;
    private int crcCheckSum;

    public StreamMuxConfig(BitSource bitSource) {
        this.localBitSource = new BitSource(bitSource);
        this.audioMuxVersion = bitSource.readBits(1);
        this.audioMuxVersionA = this.audioMuxVersion == 1 ? bitSource.readBits(1) : 0;
        if (this.audioMuxVersionA == 0) {
            if (this.audioMuxVersion == 1) {
                logger.warning("taraBufferFullness = LatmGetValue() after if(audioMuxVersionA == 0) not implemented");
            }
            this.streamCnt = 0;
            this.allStreamsSameTimeFraming = bitSource.readBits(1);
            this.numSubFrames = bitSource.readBits(6);
            this.numProgram = bitSource.readBits(4);
            this.streamID = new int[this.numProgram + 1][];
            for (int prog = 0; prog <= this.numProgram; ++prog) {
                this.programConfigList.add(new ProgramConfig(bitSource, prog));
            }
            this.otherDataPresent = bitSource.readBits(1);
            this.crcCheckPresent = bitSource.readBits(1);
            if (this.crcCheckPresent == 1) {
                this.crcCheckSum = bitSource.readBits(8);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("StreamMuxConfig"));
        t.add(new DefaultMutableTreeNode(new KVP("audioMuxVersion", this.audioMuxVersion, this.audioMuxVersion == 0 ? "audioMuxVersionA = 0" : null)));
        if (this.audioMuxVersion == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("audioMuxVersionA", this.audioMuxVersionA, null)));
        }
        if (this.audioMuxVersionA == 0) {
            if (this.audioMuxVersion == 1) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("taraBufferFullness = LatmGetValue()")));
            }
            t.add(new DefaultMutableTreeNode(new KVP("allStreamsSameTimeFraming", this.allStreamsSameTimeFraming, null)));
            t.add(new DefaultMutableTreeNode(new KVP("numSubFrames", this.numSubFrames, "number of SubFrames:" + (this.numSubFrames + 1))));
            t.add(new DefaultMutableTreeNode(new KVP("numProgram", this.numProgram, "number of Programs:" + (this.numProgram + 1))));
            Utils.addListJTree(t, this.programConfigList, modus, "ProgramConfigs");
            t.add(new DefaultMutableTreeNode(new KVP("otherDataPresent", this.otherDataPresent, null)));
            t.add(new DefaultMutableTreeNode(new KVP("crcCheckPresent", this.crcCheckPresent, null)));
            if (this.crcCheckPresent == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("crcCheckSum", this.crcCheckSum, null)));
            }
        }
        return t;
    }

    public int getAudioMuxVersionA() {
        return this.audioMuxVersionA;
    }

    public int getNumSubFrames() {
        return this.numSubFrames;
    }

    public int getAllStreamsSameTimeFraming() {
        return this.allStreamsSameTimeFraming;
    }

    public static LookUpList getFrameLengthTypeList() {
        return frameLengthTypeList;
    }

    public static void setFrameLengthTypeList(LookUpList frameLengthTypeList) {
        StreamMuxConfig.frameLengthTypeList = frameLengthTypeList;
    }

    public int[] getProgSIndx() {
        return this.progSIndx;
    }

    public void setProgSIndx(int[] progSIndx) {
        this.progSIndx = progSIndx;
    }

    public int[] getLaySIndx() {
        return this.laySIndx;
    }

    public void setLaySIndx(int[] laySIndx) {
        this.laySIndx = laySIndx;
    }

    public int[][] getStreamID() {
        return this.streamID;
    }

    public void setStreamID(int[][] streamID) {
        this.streamID = streamID;
    }

    public int[] getFrameLengthType() {
        return this.frameLengthType;
    }

    public void setFrameLengthType(int[] frameLengthType) {
        this.frameLengthType = frameLengthType;
    }

    public int[] getLatmBufferFullness() {
        return this.latmBufferFullness;
    }

    public void setLatmBufferFullness(int[] latmBufferFullness) {
        this.latmBufferFullness = latmBufferFullness;
    }

    public int getAudioMuxVersion() {
        return this.audioMuxVersion;
    }

    public void setAudioMuxVersion(int audioMuxVersion) {
        this.audioMuxVersion = audioMuxVersion;
    }

    public int getNumProgram() {
        return this.numProgram;
    }

    public void setNumProgram(int numProgram) {
        this.numProgram = numProgram;
    }

    public int getStreamCnt() {
        return this.streamCnt;
    }

    public void setStreamCnt(int streamCnt) {
        this.streamCnt = streamCnt;
    }

    public List<ProgramConfig> getProgramConfigList() {
        return this.programConfigList;
    }

    public void setProgramConfigList(List<ProgramConfig> programConfigList) {
        this.programConfigList = programConfigList;
    }

    public static Logger getLogger() {
        return logger;
    }

    public void setAudioMuxVersionA(int audioMuxVersionA) {
        this.audioMuxVersionA = audioMuxVersionA;
    }

    public void setAllStreamsSameTimeFraming(int allStreamsSameTimeFraming) {
        this.allStreamsSameTimeFraming = allStreamsSameTimeFraming;
    }

    public void setNumSubFrames(int numSubFrames) {
        this.numSubFrames = numSubFrames;
    }

    public void setOtherDataPresent(int otherDataPresent) {
        this.otherDataPresent = otherDataPresent;
    }

    public int getOtherDataPresent() {
        return this.otherDataPresent;
    }

    class ProgramConfig
    implements TreeNode {
        private List<LayerConfig> layerConfigList = new ArrayList<LayerConfig>();
        private int numLayer;

        public List<LayerConfig> getLayerConfigList() {
            return this.layerConfigList;
        }

        public ProgramConfig(BitSource bitSource, int prog) {
            this.numLayer = bitSource.readBits(3);
            StreamMuxConfig.this.streamID[prog] = new int[this.numLayer + 1];
            for (int lay = 0; lay <= this.numLayer; ++lay) {
                this.layerConfigList.add(new LayerConfig(bitSource, prog, lay));
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ProgramConfig"));
            t.add(new DefaultMutableTreeNode(new KVP("numLayer", this.numLayer, "number of Layers:" + (this.numLayer + 1))));
            Utils.addListJTree(t, this.layerConfigList, modus, "layerConfigs");
            return t;
        }

        public int getNumLayer() {
            return this.numLayer;
        }

        class LayerConfig
        implements TreeNode {
            AudioSpecificConfig audioSpecificConfig;
            private int prog;
            private int lay;
            private int useSameConfig;
            private BitSource localBitSource3;

            public AudioSpecificConfig getAudioSpecificConfig() {
                return this.audioSpecificConfig;
            }

            public int getProg() {
                return this.prog;
            }

            public int getLay() {
                return this.lay;
            }

            public int getUseSameConfig() {
                return this.useSameConfig;
            }

            public BitSource getLocalBitSource3() {
                return this.localBitSource3;
            }

            public LayerConfig(BitSource bitSource, int prog, int lay) {
                this.localBitSource3 = new BitSource(bitSource);
                this.prog = prog;
                this.lay = lay;
                StreamMuxConfig.this.progSIndx[StreamMuxConfig.this.streamCnt] = prog;
                StreamMuxConfig.this.laySIndx[StreamMuxConfig.this.streamCnt] = lay;
                StreamMuxConfig.this.streamID[prog][lay] = StreamMuxConfig.this.streamCnt++;
                this.useSameConfig = prog == 0 && lay == 0 ? 0 : bitSource.readBits(1);
                if (this.useSameConfig == 0) {
                    if (StreamMuxConfig.this.audioMuxVersion == 0) {
                        this.audioSpecificConfig = new AudioSpecificConfig(bitSource);
                    } else {
                        logger.info("LayerConfig: }else{ of if (audioMuxVersion == 0)  not implemented");
                    }
                }
                StreamMuxConfig.this.frameLengthType[StreamMuxConfig.this.streamID[prog][lay]] = bitSource.readBits(3);
                if (StreamMuxConfig.this.frameLengthType[StreamMuxConfig.this.streamID[prog][lay]] == 0) {
                    StreamMuxConfig.this.latmBufferFullness[StreamMuxConfig.this.streamID[prog][lay]] = bitSource.readBits(8);
                }
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("LayerConfig"));
                t.add(new DefaultMutableTreeNode(new KVP("useSameConfig", this.useSameConfig, null)));
                if (this.useSameConfig == 0 && StreamMuxConfig.this.audioMuxVersion == 0) {
                    t.add(this.audioSpecificConfig.getJTreeNode(modus));
                }
                t.add(new DefaultMutableTreeNode(new KVP("frameLengthType[streamID [" + this.prog + "][" + this.lay + "]]", StreamMuxConfig.this.frameLengthType[StreamMuxConfig.this.streamID[this.prog][this.lay]], frameLengthTypeList.get(StreamMuxConfig.this.frameLengthType[StreamMuxConfig.this.streamID[this.prog][this.lay]]))));
                if (StreamMuxConfig.this.frameLengthType[StreamMuxConfig.this.streamID[this.prog][this.lay]] == 0) {
                    t.add(new DefaultMutableTreeNode(new KVP("latmBufferFullness[streamID[" + this.prog + "][" + this.lay + "]]", StreamMuxConfig.this.latmBufferFullness[StreamMuxConfig.this.streamID[this.prog][this.lay]], null)));
                }
                return t;
            }
        }
    }
}

