/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;

public class AC4SgiSpecifier
implements TreeNode {
    private static final Logger logger = Logger.getLogger(AC4SgiSpecifier.class.getName());
    private int group_index;
    private int bitstream_version;

    public AC4SgiSpecifier(BitSource bs, int bitstream_version) {
        this.bitstream_version = bitstream_version;
        if (bitstream_version == 1) {
            logger.warning("ac4_substream_group_info not implemented");
        } else {
            this.group_index = bs.readBits(3);
            if (this.group_index == 7) {
                this.group_index += bs.variable_bits(2);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ac4_sgi_specifier"));
        if (this.bitstream_version == 1) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("ac4_substream_group_info")));
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("group_index", this.group_index, null)));
        }
        return t;
    }

    public int getGroup_index() {
        return this.group_index;
    }
}

