/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SubstreamInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4Toc;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4SubstreamInfoChan
extends AC4SubstreamInfo
implements TreeNode {
    LookUpList channel_mode_list = new LookUpList.Builder().add(0, "Mono").add(1, "Stereo").add(2, "3.0").add(3, "5.0").add(4, "5.1").add(5, "7.0: 3/4/0 (L, C, R, Ls, Rs, Lrs, Rrs)").add(6, "7.1: 3/4/0.1 (L, C, R, Ls, Rs, Lrs, Rrs, LFE)").add(7, "7.0: 5/2/0 (L, C, R, Lw, Rw, Ls, Rs)").add(8, "7.1: 5/2/0.1 (L, C, R, Lw, Rw, Ls, Rs, LFE)").add(9, "7.0: 3/2/2 (L, C, R, Ls, Rs, Vhl, Vhr)").add(10, "7.1: 3/2/2.1 (L, C, R, Ls, Rs, Vhl, Vhr, LFE)").add(11, "7.0.4").add(12, "7.1.4").add(13, "9.0.4").add(14, "9.1.4").add(15, "22.2").add(16, 255, "Reserved").build();
    private int channel_mode;
    private int b_4_back_channels_present;
    private int b_centre_present;
    private int top_channels_present;
    private AC4Toc parentAc4Toc;
    private int b_substreams_present;
    private int b_sf_multiplier;
    private int sf_multiplier;
    private int b_bitrate_info;
    private int bitrate_indicator;
    private int add_ch_base;
    private int substream_index;

    public AC4SubstreamInfoChan(BitSource bs, AC4Toc parentAc4Toc, int b_substreams_present) {
        this.parentAc4Toc = parentAc4Toc;
        this.b_substreams_present = b_substreams_present;
        this.channel_mode = AC4SubstreamInfoChan.readChannelMode(bs);
        if (this.channel_mode == 16) {
            this.channel_mode += bs.variable_bits(2);
        }
        if (this.channel_mode == 11 || this.channel_mode == 12 || this.channel_mode == 13 || this.channel_mode == 14) {
            this.b_4_back_channels_present = bs.readBits(1);
            this.b_centre_present = bs.readBits(1);
            this.top_channels_present = bs.readBits(2);
        }
        if (parentAc4Toc.getFs_index() == 1) {
            this.b_sf_multiplier = bs.readBits(1);
            if (this.b_sf_multiplier == 1) {
                this.sf_multiplier = bs.readBits(1);
            }
        }
        this.b_bitrate_info = bs.readBits(1);
        if (this.b_bitrate_info == 1) {
            this.bitrate_indicator = AC4SubstreamInfoChan.readBitrateIndiciator(bs);
        }
        if (this.channel_mode == 7 || this.channel_mode == 8 || this.channel_mode == 9 || this.channel_mode == 10) {
            this.add_ch_base = bs.readBits(1);
        }
        for (int i = 0; i < 1; ++i) {
            int b_audio_ndot = bs.readBits(1);
            this.b_audio_ndot_list.add(new AC4SubstreamInfo.BAudioNdot(this, b_audio_ndot));
        }
        if (b_substreams_present == 1) {
            this.substream_index = bs.readBits(2);
            if (this.substream_index == 3) {
                this.substream_index += bs.variable_bits(2);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ac4_substream_info_chan"));
        t.add(new DefaultMutableTreeNode(new KVP("channel_mode", this.channel_mode, this.channel_mode_list.get(this.channel_mode))));
        if (this.channel_mode == 11 || this.channel_mode == 12 || this.channel_mode == 13 || this.channel_mode == 14) {
            t.add(new DefaultMutableTreeNode(new KVP("b_4_back_channels_present", this.b_4_back_channels_present, null)));
            t.add(new DefaultMutableTreeNode(new KVP("b_centre_present", this.b_centre_present, null)));
            t.add(new DefaultMutableTreeNode(new KVP("top_channels_present", this.top_channels_present, null)));
        }
        if (this.parentAc4Toc.getFs_index() == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("b_sf_multiplier", this.b_sf_multiplier, null)));
            if (this.b_sf_multiplier == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("sf_multiplier", this.sf_multiplier, null)));
            }
        }
        if (this.parentAc4Toc.getFs_index() == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("b_sf_multiplier", this.b_sf_multiplier, null)));
            if (this.b_sf_multiplier == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("sf_multiplier", this.sf_multiplier, null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("b_bitrate_info", this.b_bitrate_info, null)));
        if (this.b_bitrate_info == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("bitrate_indicator", this.bitrate_indicator, bitrate_indicator_list.get(this.bitrate_indicator))));
        }
        if (this.channel_mode == 7 || this.channel_mode == 8 || this.channel_mode == 9 || this.channel_mode == 10) {
            t.add(new DefaultMutableTreeNode(new KVP("add_ch_base", this.add_ch_base, null)));
        }
        Utils.addListJTree(t, this.b_audio_ndot_list, modus, "b_audio_ndots");
        if (this.b_substreams_present == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("substream_index", this.substream_index, null)));
        }
        return t;
    }

    private static int readChannelMode(BitSource bs) {
        int bit1 = bs.readBits(1);
        if (bit1 == 0) {
            return 0;
        }
        int bit2 = bs.readBits(1);
        if (bit2 == 0) {
            return 1;
        }
        int bits34 = bs.readBits(2);
        if (bits34 == 0) {
            return 2;
        }
        if (bits34 == 1) {
            return 3;
        }
        if (bits34 == 2) {
            return 4;
        }
        int bits567 = bs.readBits(3);
        if (bits567 == 0) {
            return 5;
        }
        if (bits567 == 1) {
            return 6;
        }
        if (bits567 == 2) {
            return 7;
        }
        if (bits567 == 3) {
            return 8;
        }
        if (bits567 == 4) {
            return 9;
        }
        if (bits567 == 5) {
            return 10;
        }
        if (bits567 == 6) {
            int bit8 = bs.readBits(1);
            if (bit8 == 0) {
                return 11;
            }
            return 12;
        }
        int bits89 = bs.readBits(2);
        if (bits89 == 0) {
            return 13;
        }
        if (bits89 == 1) {
            return 14;
        }
        if (bits89 == 2) {
            return 15;
        }
        return 16;
    }
}

