/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SubstreamInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4Toc;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4SubstreamInfoObj
extends AC4SubstreamInfo
implements TreeNode {
    LookUpList n_objects_code_list = new LookUpList.Builder().add(0, "b_lfe").add(1, "1+b_lfe").add(2, "2+b_lfe").add(3, "3+b_lfe").add(4, "5+b_lfe").add(5, 7, "reserved").build();
    LookUpList bed_chan_assign_code_list = new LookUpList.Builder().add(0, "L, R (2.0.0)").add(1, "L, R, C (3.0.0)").add(2, "L, R, C, LFE, Ls, Rs (5.1.0)").add(3, "L, R, C, LFE, Ls, Rs, Tl, Tr (5.1.2)").add(4, "L, R, C, LFE, Ls, Rs, Tfl, Tfr, Tbl, Tbr (5.1.4)").add(5, "L, R, C, LFE, Ls, Rs, Lb, Rb (7.1.0)").add(6, "L, R, C, LFE, Ls, Rs, Lb, Rb, Tl, Tr (7.1.2)").add(7, "L, R, C, LFE, Ls, Rs, Lb, Rb, Tfl, Tfr, Tbl,Tbr (7.1.4)").build();
    private AC4Toc parentAc4Toc;
    private int n_objects_code;
    private int b_dynamic_objects;
    private int b_lfe;
    private int b_bed_objects;
    private int b_bed_start;
    private int b_ch_assign_code;
    private int bed_chan_assign_code;
    private int b_nonstd_bed_channel_assignment;
    private int nonstd_bed_channel_assignment_mask;
    private int std_bed_channel_assignment_mask;
    private int b_isf;
    private int b_isf_start;
    private int isf_config;
    private int res_bytes;
    private byte[] reserved_data;
    private int b_sf_multiplier;
    private int sf_multiplier;
    private int b_bitrate_info;
    private int bitrate_indicator;
    private int substream_index;
    private int sus_ver;
    private int b_substreams_present;

    public AC4SubstreamInfoObj(BitSource bs, AC4Toc parentAc4Toc, int b_substreams_present) {
        this.parentAc4Toc = parentAc4Toc;
        this.b_substreams_present = b_substreams_present;
        this.n_objects_code = bs.readBits(3);
        this.b_dynamic_objects = bs.readBits(1);
        if (this.b_dynamic_objects == 1) {
            this.b_lfe = bs.readBits(1);
        } else {
            this.b_bed_objects = bs.readBits(1);
            if (this.b_bed_objects == 1) {
                this.b_bed_start = bs.readBits(1);
                if (this.b_bed_start == 1) {
                    this.b_ch_assign_code = bs.readBits(1);
                    if (this.b_ch_assign_code == 1) {
                        this.bed_chan_assign_code = bs.readBits(3);
                    } else {
                        this.b_nonstd_bed_channel_assignment = bs.readBits(1);
                        if (this.b_nonstd_bed_channel_assignment == 1) {
                            this.nonstd_bed_channel_assignment_mask = bs.readBits(17);
                        } else {
                            this.std_bed_channel_assignment_mask = bs.readBits(10);
                        }
                    }
                }
            } else {
                this.b_isf = bs.readBits(1);
                if (this.b_isf == 1) {
                    this.b_isf_start = bs.readBits(1);
                    if (this.b_isf_start == 1) {
                        this.isf_config = bs.readBits(3);
                    }
                } else {
                    this.res_bytes = bs.readBits(4);
                    this.reserved_data = bs.readUnalignedBytes(this.res_bytes);
                }
            }
        }
        if (parentAc4Toc.getFs_index() == 1) {
            this.b_sf_multiplier = bs.readBits(1);
            if (this.b_sf_multiplier == 1) {
                this.sf_multiplier = bs.readBits(1);
            }
        }
        this.b_bitrate_info = bs.readBits(1);
        if (this.b_bitrate_info == 1) {
            this.bitrate_indicator = AC4SubstreamInfoObj.readBitrateIndiciator(bs);
        }
        for (int i = 0; i < 1; ++i) {
            int b_audio_ndot = bs.readBits(1);
            this.b_audio_ndot_list.add(new AC4SubstreamInfo.BAudioNdot(this, b_audio_ndot));
        }
        if (b_substreams_present == 1) {
            this.substream_index = bs.readBits(2);
            if (this.substream_index == 3) {
                this.substream_index += bs.variable_bits(2);
            }
        }
        this.sus_ver = 1;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ac4_substream_info_obj"));
        t.add(new DefaultMutableTreeNode(new KVP("n_objects_code", this.n_objects_code, this.n_objects_code_list.get(this.n_objects_code))));
        t.add(new DefaultMutableTreeNode(new KVP("b_dynamic_objects", this.b_dynamic_objects, null)));
        if (this.b_dynamic_objects == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("b_lfe", this.b_lfe, null)));
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("b_bed_objects", this.b_bed_objects, null)));
            if (this.b_bed_objects == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("b_bed_start", this.b_bed_start, null)));
                if (this.b_bed_start == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("b_ch_assign_code", this.b_ch_assign_code, null)));
                    if (this.b_ch_assign_code == 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("bed_chan_assign_code", this.bed_chan_assign_code, this.bed_chan_assign_code_list.get(this.bed_chan_assign_code))));
                    } else {
                        t.add(new DefaultMutableTreeNode(new KVP("b_nonstd_bed_channel_assignment", this.b_nonstd_bed_channel_assignment, null)));
                        if (this.b_nonstd_bed_channel_assignment == 1) {
                            t.add(new DefaultMutableTreeNode(new KVP("nonstd_bed_channel_assignment_mask", this.nonstd_bed_channel_assignment_mask, null)));
                        } else {
                            t.add(new DefaultMutableTreeNode(new KVP("std_bed_channel_assignment_mask", this.std_bed_channel_assignment_mask, null)));
                        }
                    }
                }
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("b_isf", this.b_isf, null)));
                if (this.b_isf == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("b_isf_start", this.b_isf_start, null)));
                    if (this.b_isf_start == 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("isf_config", this.isf_config, null)));
                    }
                } else {
                    t.add(new DefaultMutableTreeNode(new KVP("res_bytes", this.res_bytes, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved_data", this.reserved_data, null)));
                }
            }
        }
        if (this.parentAc4Toc.getFs_index() == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("b_sf_multiplier", this.b_sf_multiplier, null)));
            if (this.b_sf_multiplier == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("sf_multiplier", this.sf_multiplier, null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("b_bitrate_info", this.b_bitrate_info, null)));
        if (this.b_bitrate_info == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("bitrate_indicator", this.bitrate_indicator, null)));
        }
        Utils.addListJTree(t, this.b_audio_ndot_list, modus, "b_audio_ndots");
        if (this.b_substreams_present == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("substream_index", this.substream_index, null)));
        }
        return t;
    }
}

