/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.RawAC4Frame;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4SyncFrame
implements TreeNode {
    private int sync_word;
    private int frame_size;
    private int frame_size2;
    RawAC4Frame raw_ac4_frame;
    private int crc_word;

    public AC4SyncFrame(byte[] data, int offset) {
        int offset1 = offset;
        this.sync_word = Utils.getInt(data, offset1, 2, 65535);
        this.frame_size = Utils.getInt(data, offset1 += 2, 2, 65535);
        offset1 += 2;
        if (this.frame_size == 65535) {
            this.frame_size2 = Utils.getInt(data, offset1, 3, 0xFFFFFF);
            offset1 += 3;
        }
        this.raw_ac4_frame = new RawAC4Frame(data, offset1);
        offset1 += this.getAC4FrameSize();
        if (this.sync_word == 44097) {
            this.crc_word = Utils.getInt(data, offset1, 2, 65535);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AC4SyncFrame"));
        t.add(new DefaultMutableTreeNode(new KVP("sync_word", this.sync_word, AC4SyncFrame.getSyncWordString(this.sync_word))));
        t.add(new DefaultMutableTreeNode(new KVP("frame_size", this.frame_size, null)));
        if (this.frame_size == 65535) {
            t.add(new DefaultMutableTreeNode(new KVP("frame_size2", this.frame_size2, null)));
        }
        t.add(this.raw_ac4_frame.getJTreeNode(modus));
        if (this.sync_word == 44097) {
            t.add(new DefaultMutableTreeNode(new KVP("crc_word", this.crc_word, null)));
        }
        return t;
    }

    private static String getSyncWordString(int sync_word) {
        if (sync_word == 44097) {
            return "CRC word is present";
        }
        if (sync_word == 44096) {
            return "CRC word is not present";
        }
        return "SyncWord not legal (should be 0xAC41 or 0xAC40)";
    }

    public int getAC4FrameSize() {
        if (this.frame_size == 65535) {
            return this.frame_size2;
        }
        return this.frame_size;
    }

    public int getSyncFrameSize() {
        int s = this.getAC4FrameSize() + 2 + 2;
        if (this.frame_size == 65535) {
            s += 3;
        }
        if (this.sync_word == 44097) {
            s += 2;
        }
        return s;
    }

    public int getSync_word() {
        return this.sync_word;
    }

    public int getFrame_size() {
        return this.frame_size;
    }

    public int getFrame_size2() {
        return this.frame_size2;
    }

    public RawAC4Frame getRaw_ac4_frame() {
        return this.raw_ac4_frame;
    }

    public int getCrc_word() {
        return this.crc_word;
    }
}

