/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4PresentationV1Info;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SgiSpecifier;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SubstreamGroupInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.SubstreamIndexTable;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4Toc
implements TreeNode {
    private static final Logger logger = Logger.getLogger(AC4Toc.class.getName());
    LookUpList frame_rate_index_list = new LookUpList.Builder().add(0, "23,976 fps").add(1, "24 fps").add(2, "25 fps").add(3, "29,97 fps").add(4, "30 fps").add(5, "47,95 fps").add(6, "48 fps").add(7, "50 fps").add(8, "59,94 fps").add(9, "60 768 fps").add(10, "100 fps").add(11, "119,88 fps").add(12, "120 fps").add(13, "(23,44) fps").add(14, "reserved").add(15, "reserved").build();
    private int bitstream_version;
    private int sequence_counter;
    private int b_wait_frames;
    private int wait_frames;
    private int br_code;
    private int fs_index;
    private int frame_rate_index;
    private int b_iframe_global;
    private int b_single_presentation;
    private int n_presentations;
    private int b_more_presentations;
    private int payload_base;
    private int b_payload_base;
    private int payload_base_minus1;
    private int b_program_id;
    private int short_program_id;
    private int b_program_uuid_present;
    private byte[] program_uuid = new byte[0];
    private List<AC4PresentationV1Info> ac4_presentation_v1_infoList = new ArrayList<AC4PresentationV1Info>();
    private List<AC4SubstreamGroupInfo> ac4_substream_group_info_list = new ArrayList<AC4SubstreamGroupInfo>();
    private SubstreamIndexTable substream_index_table;

    public AC4Toc(BitSource bs) {
        this.bitstream_version = bs.readBits(2);
        if (this.bitstream_version == 3) {
            this.bitstream_version += bs.variable_bits(2);
        }
        this.sequence_counter = bs.readBits(10);
        this.b_wait_frames = bs.readBits(1);
        if (this.b_wait_frames == 1) {
            this.wait_frames = bs.readBits(3);
            if (this.wait_frames > 0) {
                this.br_code = bs.readBits(2);
            }
        }
        this.fs_index = bs.readBits(1);
        this.frame_rate_index = bs.readBits(4);
        this.b_iframe_global = bs.readBits(1);
        this.b_single_presentation = bs.readBits(1);
        if (this.b_single_presentation == 1) {
            this.n_presentations = 1;
        } else {
            this.b_more_presentations = bs.readBits(1);
            this.n_presentations = this.b_more_presentations == 1 ? bs.variable_bits(2) + 2 : 0;
        }
        this.payload_base = 0;
        this.b_payload_base = bs.readBits(1);
        if (this.b_payload_base == 1) {
            this.payload_base_minus1 = bs.readBits(5);
            this.payload_base = this.payload_base_minus1 + 1;
            if (this.payload_base == 32) {
                this.payload_base += bs.variable_bits(3);
            }
        }
        if (this.bitstream_version <= 1) {
            logger.warning("if (bitstream_version <= 1) { not implemented");
        } else {
            this.b_program_id = bs.readBits(1);
            if (this.b_program_id == 1) {
                this.short_program_id = bs.readBits(16);
                this.b_program_uuid_present = bs.readBits(1);
                if (this.b_program_uuid_present == 1) {
                    this.program_uuid = bs.readUnalignedBytes(16);
                }
            }
            for (int i = 0; i < this.n_presentations; ++i) {
                AC4PresentationV1Info ac4_presentation_v1_info = new AC4PresentationV1Info(bs, this);
                this.ac4_presentation_v1_infoList.add(ac4_presentation_v1_info);
            }
            int total_n_substream_groups = 1 + AC4Toc.getMaxGroupIndex(this.ac4_presentation_v1_infoList);
            for (int j = 0; j < total_n_substream_groups; ++j) {
                AC4SubstreamGroupInfo ac4_substream_group_info = new AC4SubstreamGroupInfo(bs, this);
                this.ac4_substream_group_info_list.add(ac4_substream_group_info);
            }
        }
        this.substream_index_table = new SubstreamIndexTable(bs);
    }

    private static int getMaxGroupIndex(List<AC4PresentationV1Info> ac4_presentation_v1_infoList2) {
        int max = 0;
        for (AC4PresentationV1Info ac4PresentationV1Info : ac4_presentation_v1_infoList2) {
            for (AC4SgiSpecifier ac4_sgi_specifier : ac4PresentationV1Info.getAc4_sgi_specifier_list()) {
                max = Integer.max(max, ac4_sgi_specifier.getGroup_index());
            }
        }
        return max;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ac4_toc"));
        t.add(new DefaultMutableTreeNode(new KVP("bitstream_version", this.bitstream_version, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sequence_counter", this.sequence_counter, null)));
        t.add(new DefaultMutableTreeNode(new KVP("b_wait_frames", this.b_wait_frames, null)));
        if (this.b_wait_frames == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("wait_frames", this.wait_frames, null)));
            if (this.wait_frames > 0) {
                t.add(new DefaultMutableTreeNode(new KVP("br_code", this.br_code, null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("fs_index", this.fs_index, this.fs_index == 0 ? "44,1 kHz" : "48 kHz")));
        t.add(new DefaultMutableTreeNode(new KVP("frame_rate_index", this.frame_rate_index, this.frame_rate_index_list.get(this.frame_rate_index))));
        t.add(new DefaultMutableTreeNode(new KVP("b_iframe_global", this.b_iframe_global, null)));
        t.add(new DefaultMutableTreeNode(new KVP("b_single_presentation", this.b_single_presentation, this.b_single_presentation == 1 ? "n_presentations = 1" : null)));
        if (this.b_single_presentation != 1) {
            t.add(new DefaultMutableTreeNode(new KVP("b_more_presentations", this.b_more_presentations, this.b_more_presentations == 0 ? "n_presentations = 0" : null)));
            if (this.b_more_presentations == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("n_presentations", this.n_presentations, null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("b_payload_base", this.b_payload_base, null)));
        if (this.b_payload_base == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("payload_base_minus1", this.payload_base_minus1, "payload_base=" + this.payload_base)));
        }
        if (this.bitstream_version <= 1) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("bitstream_version <= 1")));
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("b_program_id", this.b_program_id, null)));
            if (this.b_program_id == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("short_program_id", this.short_program_id, null)));
                t.add(new DefaultMutableTreeNode(new KVP("b_program_uuid_present", this.b_program_uuid_present, null)));
                if (this.b_program_uuid_present == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("program_uuid", this.program_uuid, null)));
                }
            }
            Utils.addListJTree(t, this.ac4_presentation_v1_infoList, modus, "ac4_presentation_v1_info(s)");
            Utils.addListJTree(t, this.ac4_substream_group_info_list, modus, "ac4_substream_group_info(s)");
            t.add(this.substream_index_table.getJTreeNode(modus));
        }
        return t;
    }

    public int getBitstream_version() {
        return this.bitstream_version;
    }

    public int getFrame_rate_index() {
        return this.frame_rate_index;
    }

    public int getSequence_counter() {
        return this.sequence_counter;
    }

    public int getB_wait_frames() {
        return this.b_wait_frames;
    }

    public int getWait_frames() {
        return this.wait_frames;
    }

    public int getBr_code() {
        return this.br_code;
    }

    public int getFs_index() {
        return this.fs_index;
    }

    public int getB_iframe_global() {
        return this.b_iframe_global;
    }

    public int getB_single_presentation() {
        return this.b_single_presentation;
    }

    public int getN_presentations() {
        return this.n_presentations;
    }

    public int getB_more_presentations() {
        return this.b_more_presentations;
    }

    public int getPayload_base() {
        return this.payload_base;
    }

    public int getB_payload_base() {
        return this.b_payload_base;
    }

    public int getPayload_base_minus1() {
        return this.payload_base_minus1;
    }

    public int getB_program_id() {
        return this.b_program_id;
    }

    public int getShort_program_id() {
        return this.short_program_id;
    }

    public int getB_program_uuid_present() {
        return this.b_program_uuid_present;
    }

    public List<AC4PresentationV1Info> getAc4_presentation_v1_infoList() {
        return this.ac4_presentation_v1_infoList;
    }
}

