/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class EmdfInfo
implements TreeNode {
    LookUpList protection_length_list = new LookUpList.Builder().add(0, "0 / Reserved").add(1, "8 bits").add(2, "32 bits").add(3, "128 bits").build();
    private int emdf_version;
    private int key_id;
    private int b_emdf_payloads_substream_info;
    private int substream_index;
    private int protection_length_primary;
    private int protection_length_secondary;
    private byte[] protection_bits_primary;
    private byte[] protection_bits_secondary;

    public EmdfInfo(BitSource bs) {
        this.emdf_version = bs.readBits(2);
        if (this.emdf_version == 3) {
            this.emdf_version += bs.variable_bits(2);
        }
        this.key_id = bs.readBits(3);
        if (this.key_id == 7) {
            this.key_id += bs.variable_bits(3);
        }
        if ((this.b_emdf_payloads_substream_info = bs.readBits(1)) == 1 && (this.substream_index = bs.readBits(2)) == 3) {
            this.substream_index += bs.variable_bits(2);
        }
        this.emdf_protection(bs);
    }

    private void emdf_protection(BitSource bs) {
        this.protection_length_primary = bs.readBits(2);
        this.protection_length_secondary = bs.readBits(2);
        this.protection_bits_primary = bs.readUnalignedBytes(EmdfInfo.noPretectionBytes(this.protection_length_primary));
        this.protection_bits_secondary = bs.readUnalignedBytes(EmdfInfo.noPretectionBytes(this.protection_length_secondary));
    }

    private static int noPretectionBytes(int protection_length) {
        switch (protection_length) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode emdf_info_node = new DefaultMutableTreeNode(new KVP("emdf_info"));
        emdf_info_node.add(new DefaultMutableTreeNode(new KVP("emdf_version", this.emdf_version, null)));
        emdf_info_node.add(new DefaultMutableTreeNode(new KVP("key_id", this.key_id, null)));
        emdf_info_node.add(new DefaultMutableTreeNode(new KVP("b_emdf_payloads_substream_info", this.b_emdf_payloads_substream_info, null)));
        if (this.b_emdf_payloads_substream_info == 1) {
            emdf_info_node.add(new DefaultMutableTreeNode(new KVP("substream_index", this.substream_index, null)));
        }
        DefaultMutableTreeNode emdf_protection_node = new DefaultMutableTreeNode(new KVP("emdf_protection"));
        emdf_protection_node.add(new DefaultMutableTreeNode(new KVP("protection_length_primary", this.protection_length_primary, this.protection_length_list.get(this.protection_length_primary))));
        emdf_protection_node.add(new DefaultMutableTreeNode(new KVP("protection_length_secondary", this.protection_length_secondary, this.protection_length_list.get(this.protection_length_secondary))));
        emdf_protection_node.add(new DefaultMutableTreeNode(new KVP("protection_bits_primary", this.protection_bits_primary, null)));
        emdf_protection_node.add(new DefaultMutableTreeNode(new KVP("protection_bits_secondary", this.protection_bits_secondary, null)));
        emdf_info_node.add(emdf_protection_node);
        return emdf_info_node;
    }
}

