/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.Utils;

public class MessageElement
implements TreeNode {
    protected byte[] data;
    protected int st;

    public MessageElement(byte[] data, int start) {
        this.data = data;
        this.st = start;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode messageElement = new DefaultMutableTreeNode(new KVP("Message Element"));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Element Code", this.getMessageElementCode(), MessageElement.getMessageElementCodeString(this.getMessageElementCode()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Data Set Number", this.getDataSetNumber(), MessageElement.getDataSetNumberString(this.getDataSetNumber()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Program Service Number", this.getProgramServiceNumber(), null)));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Element Data Length", this.getMessageElementDataLength(), null)));
        return messageElement;
    }

    public int getMessageElementCode() {
        return Utils.getInt(this.data, this.st, 1, 255);
    }

    protected int getDataSetNumber() {
        return Utils.getInt(this.data, this.st + 1, 1, 255);
    }

    protected int getProgramServiceNumber() {
        return Utils.getInt(this.data, this.st + 2, 1, 255);
    }

    protected int getMessageElementDataLength() {
        return Utils.getInt(this.data, this.st + 3, 1, 255);
    }

    public int getLength() {
        return this.getMessageElementDataLength() + 4;
    }

    public static String getDataSetNumberString(int dsn) {
        if (1 <= dsn && dsn <= 253) {
            return "Specific data set";
        }
        if (dsn == 0) {
            return "Current data set";
        }
        if (dsn == 254) {
            return "All data sets except the current data set";
        }
        if (dsn == 255) {
            return "All data sets";
        }
        return "return invalid value";
    }

    public String getMessageElementCodeString() {
        return MessageElement.getMessageElementCodeString(this.getMessageElementCode());
    }

    public static String getMessageElementCodeString(int mec) {
        if (236 <= mec && mec <= 252) {
            return "Astra ADR 3) special commands";
        }
        switch (mec) {
            case 1: {
                return "PI";
            }
            case 2: {
                return "PS";
            }
            case 3: {
                return "TA/TP";
            }
            case 4: {
                return "DI";
            }
            case 5: {
                return "MS";
            }
            case 6: {
                return "PIN";
            }
            case 7: {
                return "PTY";
            }
            case 8: {
                return "Paging call with numeric message (10 digits)";
            }
            case 9: {
                return "Real time clock correction";
            }
            case 10: {
                return "RT";
            }
            case 11: {
                return "PSN enable/disable";
            }
            case 12: {
                return "Paging call without message";
            }
            case 13: {
                return "Real time clock";
            }
            case 14: {
                return "RDS level";
            }
            case 15: {
                return "ARI area (BK)";
            }
            case 16: {
                return "International paging with functions message";
            }
            case 17: {
                return "International paging with numeric message (15 digits)";
            }
            case 18: {
                return "Transmitter network group designation";
            }
            case 19: {
                return "AF";
            }
            case 20: {
                return "EON - AF";
            }
            case 21: {
                return "EON - TA control";
            }
            case 22: {
                return "Group sequence";
            }
            case 23: {
                return "Request message";
            }
            case 24: {
                return "Message acknowledgment";
            }
            case 25: {
                return "CT On/Off";
            }
            case 26: {
                return "Slow Labeling codes";
            }
            case 27: {
                return "Paging call with alphanumeric message (80 characters)";
            }
            case 28: {
                return "Data set select";
            }
            case 29: {
                return "Reference input select";
            }
            case 30: {
                return "RDS On/Off";
            }
            case 31: {
                return "ARI level";
            }
            case 32: {
                return "Paging call with numeric message (18 digits)";
            }
            case 33: {
                return "ARI On/Off";
            }
            case 34: {
                return "RDS phase";
            }
            case 35: {
                return "Site address";
            }
            case 36: {
                return "Free-format group";
            }
            case 37: {
                return "IH";
            }
            case 38: {
                return "TDC";
            }
            case 39: {
                return "Encoder address";
            }
            case 40: {
                return "Make PSN list";
            }
            case 41: {
                return "Group variant code sequence";
            }
            case 42: {
                return "TA control";
            }
            case 43: {
                return "EWS";
            }
            case 44: {
                return "Communication mode";
            }
            case 45: {
                return "Manufacturer's specific command";
            }
            case 46: {
                return "Linkage information";
            }
            case 47: {
                return "PS character code table selection";
            }
            case 48: {
                return "TMC";
            }
            case 49: {
                return "EPP transmitter information";
            }
            case 50: {
                return "EPP call without additional message";
            }
            case 51: {
                return "EPP national and international call with alphanumeric message";
            }
            case 52: {
                return "EPP national and international call with variable length numeric message";
            }
            case 53: {
                return "EPP national and international call with variable length functions message";
            }
            case 56: {
                return "Extended group sequence";
            }
            case 58: {
                return "Encoder Access Right";
            }
            case 59: {
                return "Communications Port Configuration - Mode";
            }
            case 60: {
                return "Communications Port Configuration - Speed";
            }
            case 61: {
                return "Communications Port Configuration - Timeout";
            }
            case 62: {
                return "PTYN";
            }
            case 64: {
                return "ODA configuration and short message command";
            }
            case 65: {
                return "ODA identification group usage sequence";
            }
            case 66: {
                return "ODA free-format group";
            }
            case 67: {
                return "ODA relative priority group sequence";
            }
            case 68: {
                return "ODA \u201cBurst mode\u201d control";
            }
            case 69: {
                return "ODA \u201cSpinning Wheel\u201d timing control";
            }
            case 70: {
                return "ODA Data / Radiotext Plus tags";
            }
            case 71: {
                return "ODA Data command access right";
            }
            case 72: {
                return "DAB Dynamic Label command";
            }
            case 170: {
                return "DAB Dynamic Label message (DL)";
            }
            case 218: {
                return "RASS";
            }
        }
        return "illegal value";
    }

    public int getStart() {
        return this.st;
    }
}

