/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElement;
import nl.digitalekabeltelevisie.util.Utils;

public class MessageElementTATP
extends MessageElement {
    public MessageElementTATP(byte[] data, int start) {
        super(data, start);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode messageElement = new DefaultMutableTreeNode(new KVP("Message Element TA/TP"));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Element Code", this.getMessageElementCode(), MessageElement.getMessageElementCodeString(this.getMessageElementCode()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Data Set Number", this.getDataSetNumber(), MessageElement.getDataSetNumberString(this.getDataSetNumber()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Program Service Number", this.getProgramServiceNumber(), null)));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Data", this.getTATP(), MessageElementTATP.getTATPString(this.getTATP()))));
        return messageElement;
    }

    protected int getTATP() {
        return Utils.getInt(this.data, this.st + 3, 1, 255);
    }

    private static String getTATPString(int tatp) {
        switch (tatp) {
            case 0: {
                return "TA=0, TP=0, This Program does not carry traffic announcements nor does it refer, via EON, to a program that does";
            }
            case 1: {
                return "TA=1, TP=0, This Program carries EON information about another programme which gives traffic information";
            }
            case 2: {
                return "TA=0, TP=1, This Program carries traffic announcements but none are being broadcast at present and may carry EON information about other traffic announcements";
            }
            case 3: {
                return "TA=1, TP=1, A traffic announcement is being broadcast on this programme at present";
            }
        }
        return "Illegal Value";
    }
}

