/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DVBSubtitlingPESDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class Segment
implements TreeNode {
    protected byte[] data_block;
    protected int offset;

    public int getSegmentType() {
        return this.getSegmentType(1);
    }

    private int getSegmentType(int localOffset) {
        return Utils.getInt(this.data_block, this.offset + localOffset, 1, 255);
    }

    public Segment(byte[] data, int offset) {
        this.data_block = data;
        this.offset = offset;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = new KVP("Segment (" + DVBSubtitlingPESDataField.getSegmentTypeString(this.getSegmentType()) + ")");
        s.add(new KVP("raw_data", this.data_block, this.offset, this.getSegmentLength() + 6));
        s.add(new KVP("segment_type", this.getSegmentType()).setDescription(DVBSubtitlingPESDataField.getSegmentTypeString(this.getSegmentType())));
        s.add(new KVP("page_id", this.getPageID()));
        s.add(new KVP("segment_length", this.getSegmentLength()));
        return s;
    }

    public int getPageID() {
        return Utils.getInt(this.data_block, this.offset + 2, 2, 65535);
    }

    public int getSegmentLength() {
        return Utils.getInt(this.data_block, this.offset + 4, 2, 65535);
    }
}

