/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DVBSubtitlingPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DisplaySet;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.PageCompositionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.util.Utils;

public class Titles
implements TreeNode {
    private List<DisplaySet> displaySets = new ArrayList<DisplaySet>();
    private DisplaySet current = null;
    private ArrayList<DisplaySet> currentEpoch = null;

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("Titles");
        Utils.addListJTree(t, this.displaySets, modus, "DisplaySets");
        return t;
    }

    public void add(DVBSubtitlingPESDataField title) {
        List<Segment> segmentList = title.getSegmentList();
        if (segmentList != null && !segmentList.isEmpty()) {
            if (segmentList.getFirst().getSegmentType() == 255) {
                if (this.current != null) {
                    if (this.currentEpoch != null) {
                        this.currentEpoch.add(this.current);
                        this.current.setEpoch(new ArrayList<DisplaySet>(this.currentEpoch));
                    }
                    this.displaySets.add(this.current);
                    this.current = null;
                }
            } else {
                if (this.current == null) {
                    this.current = new DisplaySet(title.getPesHandler(), title.getPesHeader().getPts());
                }
                for (Segment segment : segmentList) {
                    PageCompositionSegment pageCompositionSegment;
                    this.current.add(segment);
                    if (segment instanceof PageCompositionSegment && ((pageCompositionSegment = (PageCompositionSegment)segment).getPageState() == 1 || pageCompositionSegment.getPageState() == 2)) {
                        this.currentEpoch = new ArrayList();
                    }
                    if (segment.getSegmentType() != 128) continue;
                    if (this.currentEpoch != null) {
                        this.currentEpoch.add(this.current);
                        this.current.setEpoch(new ArrayList<DisplaySet>(this.currentEpoch));
                    }
                    this.displaySets.add(this.current);
                    this.current = null;
                }
            }
        }
    }

    public List<DisplaySet> getDisplaySets() {
        return this.displaySets;
    }
}

