/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class DRCSLink
implements TreeNode {
    private final byte[] data_block;
    private int offset;

    public DRCSLink(byte[] data, int offset) {
        this.data_block = data;
        this.offset = offset;
    }

    public KVP getJTreeNode(String name) {
        if (this.getPageTens() == 255 && this.getPageUnits() == 15) {
            return new KVP("Object Link not used");
        }
        KVP kvp = new KVP(name + TxtDataField.formatPageNo(this.getMagazine(), this.getPageNo(), 16255));
        kvp.add(new KVP("Magazine ", this.getMagazine()));
        kvp.add(new KVP("pageTens ", this.getPageTens()));
        kvp.add(new KVP("pageUnits ", this.getPageUnits()));
        kvp.add(new KVP("numberOfSubpages", this.getNumberOfSubpages(), "highest S1 sub-code value transmitted " + (1 + this.getNumberOfSubpages())));
        return kvp;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return this.getJTreeNode("DRCS Link");
    }

    public int getMagazine() {
        return Utils.getHammingReverseByte(this.data_block[this.offset]) & 7;
    }

    public int getPageTens() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 1]);
    }

    public int getPageUnits() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 2]);
    }

    public int getNumberOfSubpages() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 3]);
    }

    public int getPageNo() {
        return this.getPageTens() * 16 + this.getPageUnits();
    }
}

